/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.api.rest.v1.entities;

import io.camunda.tasklist.entities.TaskImplementation;
import io.camunda.tasklist.entities.TaskState;
import io.camunda.tasklist.queries.DateFilter;
import io.camunda.tasklist.queries.RangeValueFilter;
import io.camunda.tasklist.queries.TaskByVariables;
import io.camunda.tasklist.queries.TaskOrderBy;
import io.camunda.tasklist.webapp.api.rest.v1.entities.IncludeVariable;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Arrays;
import java.util.Objects;

@Schema(description="Request object to search tasks by provided params.")
public class TaskSearchRequest {
    @Schema(description="The state of the tasks.")
    private TaskState state;
    @Schema(description="Are the tasks assigned?")
    private Boolean assigned;
    @Schema(description="Who is assigned to the tasks?")
    private String assignee;
    @Schema(description="The assignee is one of the given assignees.")
    private String[] assignees;
    @Schema(description="What's the BPMN flow node?")
    private String taskDefinitionId;
    @Schema(description="Given group is in candidate groups list.")
    private String candidateGroup;
    @Schema(description="At least one of the given groups is in candidate groups list.")
    private String[] candidateGroups;
    @Schema(description="Given user is in candidate user list.")
    private String candidateUser;
    @Schema(description="At least one of the given users is in candidate user list.")
    private String[] candidateUsers;
    @Schema(description="Reference to process definition (renamed equivalent of TaskQuery.processDefinitionId field).")
    private String processDefinitionKey;
    @Schema(description="Reference to process instance (renamed equivalent of TaskQuery.processInstanceId field)")
    private String processInstanceKey;
    @Schema(description="Size of tasks page (default = 50).")
    private int pageSize = 50;
    @Schema(description="A range of follow-up dates for the tasks to search for.")
    private DateFilter followUpDate;
    @Schema(description="A range of due dates for the tasks to search for.")
    private DateFilter dueDate;
    @ArraySchema(arraySchema=@Schema(description="An array of filter clauses specifying the variables to filter for.<br>If defined, the query returns only tasks to which all clauses apply.<br>However, it's important to note that this filtering mechanism is<br>designed to work exclusively with truncated variables. This means<br>variables of a larger size are not compatible with this filter, and<br>attempts to use them may result in inaccurate or incomplete query results."))
    private TaskByVariables[] taskVariables;
    @ArraySchema(arraySchema=@Schema(description="An array of Tenant IDs to filter tasks. When multi-tenancy is<br>enabled, tasks associated with the specified tenant IDs are returned;<br>if disabled, this parameter is ignored."))
    private String[] tenantIds;
    @ArraySchema(arraySchema=@Schema(description="An array of objects specifying the fields to sort the results by."))
    private TaskOrderBy[] sort;
    @ArraySchema(arraySchema=@Schema(description="Used to return a paginated result. Array of values that should be copied from sortValues of one of the tasks from the current search results page.<br>It enables the API to return a page of tasks that directly follow the task identified by the provided values, with respect to the sorting order."))
    private String[] searchAfter;
    @ArraySchema(arraySchema=@Schema(description="Used to return a paginated result. Array of values that should be copied from sortValues of one of the tasks from the current search results page.<br>It enables the API to return a page of tasks that directly follow or are equal to the task identified by the provided values, with respect to the sorting order."))
    private String[] searchAfterOrEqual;
    @ArraySchema(arraySchema=@Schema(description="Used to return a paginated result. Array of values that should be copied from sortValues of one of the tasks from the current search results page.<br>It enables the API to return a page of tasks that directly precede the task identified by the provided values, with respect to the sorting order."))
    private String[] searchBefore;
    @ArraySchema(arraySchema=@Schema(description="Used to return a paginated result. Array of values that should be copied from sortValues of one of the tasks from the current search results page.<br>It enables the API to return a page of tasks that directly precede or are equal to the task identified by the provided values, with respect to the sorting order."))
    private String[] searchBeforeOrEqual;
    @ArraySchema(arraySchema=@Schema(description="An array used to specify a list of variable names that should be included in the response when querying tasks.<br>This field allows users to selectively retrieve specific variables associated with the tasks returned in the search results."))
    private IncludeVariable[] includeVariables;
    private TaskImplementation implementation;
    @Schema(description="The conditions applied on priority field.")
    private RangeValueFilter priority;

    public TaskState getState() {
        return this.state;
    }

    public TaskSearchRequest setState(TaskState state) {
        this.state = state;
        return this;
    }

    public Boolean getAssigned() {
        return this.assigned;
    }

    public TaskSearchRequest setAssigned(Boolean assigned) {
        this.assigned = assigned;
        return this;
    }

    public String getAssignee() {
        return this.assignee;
    }

    public TaskSearchRequest setAssignee(String assignee) {
        this.assignee = assignee;
        return this;
    }

    public String getTaskDefinitionId() {
        return this.taskDefinitionId;
    }

    public TaskSearchRequest setTaskDefinitionId(String taskDefinitionId) {
        this.taskDefinitionId = taskDefinitionId;
        return this;
    }

    public String getCandidateGroup() {
        return this.candidateGroup;
    }

    public TaskSearchRequest setCandidateGroup(String candidateGroup) {
        this.candidateGroup = candidateGroup;
        return this;
    }

    public String getCandidateUser() {
        return this.candidateUser;
    }

    public TaskSearchRequest setCandidateUser(String candidateUser) {
        this.candidateUser = candidateUser;
        return this;
    }

    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public TaskSearchRequest setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    public String getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    public TaskSearchRequest setProcessInstanceKey(String processInstanceKey) {
        this.processInstanceKey = processInstanceKey;
        return this;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public TaskSearchRequest setPageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public DateFilter getFollowUpDate() {
        return this.followUpDate;
    }

    public TaskSearchRequest setFollowUpDate(DateFilter followUpDate) {
        this.followUpDate = followUpDate;
        return this;
    }

    public DateFilter getDueDate() {
        return this.dueDate;
    }

    public TaskSearchRequest setDueDate(DateFilter dueDate) {
        this.dueDate = dueDate;
        return this;
    }

    public TaskOrderBy[] getSort() {
        return this.sort;
    }

    public TaskSearchRequest setSort(TaskOrderBy[] sort) {
        this.sort = sort;
        return this;
    }

    public TaskByVariables[] getTaskVariables() {
        return this.taskVariables;
    }

    public TaskSearchRequest setTaskVariables(TaskByVariables[] taskVariables) {
        this.taskVariables = taskVariables;
        return this;
    }

    public String[] getTenantIds() {
        return this.tenantIds;
    }

    public TaskSearchRequest setTenantIds(String[] tenantIds) {
        this.tenantIds = tenantIds;
        return this;
    }

    public String[] getSearchAfter() {
        return this.searchAfter;
    }

    public TaskSearchRequest setSearchAfter(String[] searchAfter) {
        this.searchAfter = searchAfter;
        return this;
    }

    public String[] getSearchAfterOrEqual() {
        return this.searchAfterOrEqual;
    }

    public TaskSearchRequest setSearchAfterOrEqual(String[] searchAfterOrEqual) {
        this.searchAfterOrEqual = searchAfterOrEqual;
        return this;
    }

    public String[] getSearchBefore() {
        return this.searchBefore;
    }

    public TaskSearchRequest setSearchBefore(String[] searchBefore) {
        this.searchBefore = searchBefore;
        return this;
    }

    public String[] getSearchBeforeOrEqual() {
        return this.searchBeforeOrEqual;
    }

    public TaskSearchRequest setSearchBeforeOrEqual(String[] searchBeforeOrEqual) {
        this.searchBeforeOrEqual = searchBeforeOrEqual;
        return this;
    }

    public IncludeVariable[] getIncludeVariables() {
        return this.includeVariables;
    }

    public TaskSearchRequest setIncludeVariables(IncludeVariable[] includeVariables) {
        this.includeVariables = includeVariables;
        return this;
    }

    public TaskImplementation getImplementation() {
        return this.implementation;
    }

    public TaskSearchRequest setImplementation(TaskImplementation implementation) {
        this.implementation = implementation;
        return this;
    }

    public String[] getAssignees() {
        return this.assignees;
    }

    public TaskSearchRequest setAssignees(String[] assignees) {
        this.assignees = assignees;
        return this;
    }

    public String[] getCandidateGroups() {
        return this.candidateGroups;
    }

    public TaskSearchRequest setCandidateGroups(String[] candidateGroups) {
        this.candidateGroups = candidateGroups;
        return this;
    }

    public String[] getCandidateUsers() {
        return this.candidateUsers;
    }

    public TaskSearchRequest setCandidateUsers(String[] candidateUsers) {
        this.candidateUsers = candidateUsers;
        return this;
    }

    public RangeValueFilter getPriority() {
        return this.priority;
    }

    public TaskSearchRequest setPriority(RangeValueFilter priority) {
        this.priority = priority;
        return this;
    }

    public int hashCode() {
        int result = Objects.hash(this.state, this.assigned, this.assignee, this.taskDefinitionId, this.candidateGroup, this.candidateUser, this.processDefinitionKey, this.processInstanceKey, this.pageSize, this.followUpDate, this.dueDate, this.implementation, this.priority);
        result = 31 * result + Arrays.hashCode(this.assignees);
        result = 31 * result + Arrays.hashCode(this.candidateGroups);
        result = 31 * result + Arrays.hashCode(this.candidateUsers);
        result = 31 * result + Arrays.hashCode(this.taskVariables);
        result = 31 * result + Arrays.hashCode(this.tenantIds);
        result = 31 * result + Arrays.hashCode(this.sort);
        result = 31 * result + Arrays.hashCode(this.searchAfter);
        result = 31 * result + Arrays.hashCode(this.searchAfterOrEqual);
        result = 31 * result + Arrays.hashCode(this.searchBefore);
        result = 31 * result + Arrays.hashCode(this.searchBeforeOrEqual);
        result = 31 * result + Arrays.hashCode(this.includeVariables);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskSearchRequest that = (TaskSearchRequest)o;
        return this.pageSize == that.pageSize && this.state == that.state && this.implementation == that.implementation && Objects.equals(this.assigned, that.assigned) && Objects.equals(this.assignee, that.assignee) && Arrays.equals(this.assignees, that.assignees) && Objects.equals(this.taskDefinitionId, that.taskDefinitionId) && Objects.equals(this.candidateGroup, that.candidateGroup) && Arrays.equals(this.candidateGroups, that.candidateGroups) && Objects.equals(this.candidateUser, that.candidateUser) && Arrays.equals(this.candidateUsers, that.candidateUsers) && Objects.equals(this.processDefinitionKey, that.processDefinitionKey) && Objects.equals(this.processInstanceKey, that.processInstanceKey) && Objects.equals(this.followUpDate, that.followUpDate) && Objects.equals(this.dueDate, that.dueDate) && Objects.equals(this.priority, that.priority) && Arrays.equals(this.taskVariables, that.taskVariables) && Arrays.equals(this.tenantIds, that.tenantIds) && Arrays.equals(this.sort, that.sort) && Arrays.equals(this.searchAfter, that.searchAfter) && Arrays.equals(this.searchAfterOrEqual, that.searchAfterOrEqual) && Arrays.equals(this.searchBefore, that.searchBefore) && Arrays.equals(this.searchBeforeOrEqual, that.searchBeforeOrEqual) && Arrays.equals(this.includeVariables, that.includeVariables);
    }

    public String toString() {
        return "TaskSearchRequest{state=" + String.valueOf(this.state) + ", assigned=" + this.assigned + ", assignee='" + this.assignee + "', assignees=" + Arrays.toString(this.assignees) + ", taskDefinitionId='" + this.taskDefinitionId + "', candidateGroup='" + this.candidateGroup + "', candidateGroups=" + Arrays.toString(this.candidateGroups) + ", candidateUser='" + this.candidateUser + "', candidateUsers=" + Arrays.toString(this.candidateUsers) + ", processDefinitionKey='" + this.processDefinitionKey + "', processInstanceKey='" + this.processInstanceKey + "', pageSize=" + this.pageSize + ", followUpDate=" + String.valueOf(this.followUpDate) + ", dueDate=" + String.valueOf(this.dueDate) + ", taskVariables=" + Arrays.toString(this.taskVariables) + ", tenantIds=" + Arrays.toString(this.tenantIds) + ", sort=" + Arrays.toString(this.sort) + ", searchAfter=" + Arrays.toString(this.searchAfter) + ", searchAfterOrEqual=" + Arrays.toString(this.searchAfterOrEqual) + ", searchBefore=" + Arrays.toString(this.searchBefore) + ", searchBeforeOrEqual=" + Arrays.toString(this.searchBeforeOrEqual) + ", includeVariables=" + Arrays.toString(this.includeVariables) + ", implementation=" + String.valueOf(this.implementation) + ", priority=" + String.valueOf(this.priority) + "}";
    }
}

