/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.api.rest.v1.controllers.internal;

import io.camunda.tasklist.webapp.api.rest.v1.controllers.ApiErrorController;
import io.camunda.tasklist.webapp.graphql.entity.UserDTO;
import io.camunda.tasklist.webapp.security.UserReader;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="User", description="This API enables querying user details.")
@RestController
@RequestMapping(value={"/v1/internal/users"}, produces={"application/json"})
public class UserInternalController
extends ApiErrorController {
    @Autowired
    private UserReader userReader;

    @Operation(summary="Get details about the current user.", responses={@ApiResponse(description="On success returned", responseCode="200", useReturnTypeSchema=true)})
    @GetMapping(value={"current"})
    public ResponseEntity<UserDTO> getCurrentUser() {
        return ResponseEntity.ok((Object)this.userReader.getCurrentUser());
    }

    @Operation(summary="Returns a new access token.", responses={@ApiResponse(description="Token successfully created and returned", responseCode="200", useReturnTypeSchema=true)})
    @GetMapping(value={"token"})
    public String getToken() {
        return this.userReader.getUserToken();
    }
}

