/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.v870.record.value.scaling;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.v870.record.ImmutableProtocol;
import io.camunda.zeebe.protocol.v870.record.value.scaling.ScaleRecordValue;
import java.util.Collection;
import java.util.Objects;
import org.immutables.value.Generated;

@ImmutableProtocol.Type(builder=Builder.class)
@Generated(from="ScaleRecordValue", generator="Immutables")
@SuppressFBWarnings
public final class ImmutableScaleRecordValue
implements ScaleRecordValue {
    private final int desiredPartitionCount;
    private final Collection<Integer> redistributedPartitions;
    private final Collection<Integer> relocatedPartitions;
    private final int messageCorrelationPartitions;
    private final long scalingPosition;
    private transient int hashCode;

    private ImmutableScaleRecordValue(int desiredPartitionCount, Collection<Integer> redistributedPartitions, Collection<Integer> relocatedPartitions, int messageCorrelationPartitions, long scalingPosition) {
        this.desiredPartitionCount = desiredPartitionCount;
        this.redistributedPartitions = redistributedPartitions;
        this.relocatedPartitions = relocatedPartitions;
        this.messageCorrelationPartitions = messageCorrelationPartitions;
        this.scalingPosition = scalingPosition;
    }

    @Override
    public int getDesiredPartitionCount() {
        return this.desiredPartitionCount;
    }

    @Override
    public Collection<Integer> getRedistributedPartitions() {
        return this.redistributedPartitions;
    }

    @Override
    public Collection<Integer> getRelocatedPartitions() {
        return this.relocatedPartitions;
    }

    @Override
    public int getMessageCorrelationPartitions() {
        return this.messageCorrelationPartitions;
    }

    @Override
    public long getScalingPosition() {
        return this.scalingPosition;
    }

    public final ImmutableScaleRecordValue withDesiredPartitionCount(int value) {
        if (this.desiredPartitionCount == value) {
            return this;
        }
        return new ImmutableScaleRecordValue(value, this.redistributedPartitions, this.relocatedPartitions, this.messageCorrelationPartitions, this.scalingPosition);
    }

    public final ImmutableScaleRecordValue withRedistributedPartitions(Collection<Integer> value) {
        if (this.redistributedPartitions == value) {
            return this;
        }
        return new ImmutableScaleRecordValue(this.desiredPartitionCount, value, this.relocatedPartitions, this.messageCorrelationPartitions, this.scalingPosition);
    }

    public final ImmutableScaleRecordValue withRelocatedPartitions(Collection<Integer> value) {
        if (this.relocatedPartitions == value) {
            return this;
        }
        return new ImmutableScaleRecordValue(this.desiredPartitionCount, this.redistributedPartitions, value, this.messageCorrelationPartitions, this.scalingPosition);
    }

    public final ImmutableScaleRecordValue withMessageCorrelationPartitions(int value) {
        if (this.messageCorrelationPartitions == value) {
            return this;
        }
        return new ImmutableScaleRecordValue(this.desiredPartitionCount, this.redistributedPartitions, this.relocatedPartitions, value, this.scalingPosition);
    }

    public final ImmutableScaleRecordValue withScalingPosition(long value) {
        if (this.scalingPosition == value) {
            return this;
        }
        return new ImmutableScaleRecordValue(this.desiredPartitionCount, this.redistributedPartitions, this.relocatedPartitions, this.messageCorrelationPartitions, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableScaleRecordValue && this.equalTo(0, (ImmutableScaleRecordValue)another);
    }

    private boolean equalTo(int synthetic, ImmutableScaleRecordValue another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.desiredPartitionCount == another.desiredPartitionCount && Objects.equals(this.redistributedPartitions, another.redistributedPartitions) && Objects.equals(this.relocatedPartitions, another.relocatedPartitions) && this.messageCorrelationPartitions == another.messageCorrelationPartitions && this.scalingPosition == another.scalingPosition;
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.desiredPartitionCount;
        h += (h << 5) + Objects.hashCode(this.redistributedPartitions);
        h += (h << 5) + Objects.hashCode(this.relocatedPartitions);
        h += (h << 5) + this.messageCorrelationPartitions;
        h += (h << 5) + Long.hashCode(this.scalingPosition);
        return h;
    }

    public String toString() {
        return "ScaleRecordValue{desiredPartitionCount=" + this.desiredPartitionCount + ", redistributedPartitions=" + this.redistributedPartitions + ", relocatedPartitions=" + this.relocatedPartitions + ", messageCorrelationPartitions=" + this.messageCorrelationPartitions + ", scalingPosition=" + this.scalingPosition + "}";
    }

    public static ImmutableScaleRecordValue copyOf(ScaleRecordValue instance) {
        if (instance instanceof ImmutableScaleRecordValue) {
            return (ImmutableScaleRecordValue)instance;
        }
        return ImmutableScaleRecordValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @ImmutableProtocol.Builder
    @Generated(from="ScaleRecordValue", generator="Immutables")
    public static final class Builder {
        private int desiredPartitionCount;
        private Collection<Integer> redistributedPartitions;
        private Collection<Integer> relocatedPartitions;
        private int messageCorrelationPartitions;
        private long scalingPosition;

        private Builder() {
        }

        public final Builder from(ScaleRecordValue instance) {
            Collection<Integer> relocatedPartitionsValue;
            Objects.requireNonNull(instance, "instance");
            this.withDesiredPartitionCount(instance.getDesiredPartitionCount());
            Collection<Integer> redistributedPartitionsValue = instance.getRedistributedPartitions();
            if (redistributedPartitionsValue != null) {
                this.withRedistributedPartitions(redistributedPartitionsValue);
            }
            if ((relocatedPartitionsValue = instance.getRelocatedPartitions()) != null) {
                this.withRelocatedPartitions(relocatedPartitionsValue);
            }
            this.withMessageCorrelationPartitions(instance.getMessageCorrelationPartitions());
            this.withScalingPosition(instance.getScalingPosition());
            return this;
        }

        public final Builder withDesiredPartitionCount(int desiredPartitionCount) {
            this.desiredPartitionCount = desiredPartitionCount;
            return this;
        }

        public final Builder withRedistributedPartitions(Collection<Integer> redistributedPartitions) {
            this.redistributedPartitions = redistributedPartitions;
            return this;
        }

        public final Builder withRelocatedPartitions(Collection<Integer> relocatedPartitions) {
            this.relocatedPartitions = relocatedPartitions;
            return this;
        }

        public final Builder withMessageCorrelationPartitions(int messageCorrelationPartitions) {
            this.messageCorrelationPartitions = messageCorrelationPartitions;
            return this;
        }

        public final Builder withScalingPosition(long scalingPosition) {
            this.scalingPosition = scalingPosition;
            return this;
        }

        public Builder clear() {
            this.desiredPartitionCount = 0;
            this.redistributedPartitions = null;
            this.relocatedPartitions = null;
            this.messageCorrelationPartitions = 0;
            this.scalingPosition = 0L;
            return this;
        }

        public ImmutableScaleRecordValue build() {
            return new ImmutableScaleRecordValue(this.desiredPartitionCount, this.redistributedPartitions, this.relocatedPartitions, this.messageCorrelationPartitions, this.scalingPosition);
        }
    }
}

