/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.v870.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.v870.record.ImmutableProtocol;
import io.camunda.zeebe.protocol.v870.record.value.UsageMetricRecordValue;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.immutables.value.Generated;

@ImmutableProtocol.Type(builder=Builder.class)
@Generated(from="UsageMetricRecordValue", generator="Immutables")
@SuppressFBWarnings
public final class ImmutableUsageMetricRecordValue
implements UsageMetricRecordValue {
    private final UsageMetricRecordValue.IntervalType intervalType;
    private final UsageMetricRecordValue.EventType eventType;
    private final long startTime;
    private final long endTime;
    private final long resetTime;
    private final Map<String, Long> counterValues;
    private final Map<String, Set<Long>> setValues;
    private transient int hashCode;

    private ImmutableUsageMetricRecordValue(UsageMetricRecordValue.IntervalType intervalType, UsageMetricRecordValue.EventType eventType, long startTime, long endTime, long resetTime, Map<String, Long> counterValues, Map<String, Set<Long>> setValues) {
        this.intervalType = intervalType;
        this.eventType = eventType;
        this.startTime = startTime;
        this.endTime = endTime;
        this.resetTime = resetTime;
        this.counterValues = counterValues;
        this.setValues = setValues;
    }

    @Override
    public UsageMetricRecordValue.IntervalType getIntervalType() {
        return this.intervalType;
    }

    @Override
    public UsageMetricRecordValue.EventType getEventType() {
        return this.eventType;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public long getEndTime() {
        return this.endTime;
    }

    @Override
    public long getResetTime() {
        return this.resetTime;
    }

    @Override
    public Map<String, Long> getCounterValues() {
        return this.counterValues;
    }

    @Override
    public Map<String, Set<Long>> getSetValues() {
        return this.setValues;
    }

    public final ImmutableUsageMetricRecordValue withIntervalType(UsageMetricRecordValue.IntervalType value) {
        if (this.intervalType == value) {
            return this;
        }
        return new ImmutableUsageMetricRecordValue(value, this.eventType, this.startTime, this.endTime, this.resetTime, this.counterValues, this.setValues);
    }

    public final ImmutableUsageMetricRecordValue withEventType(UsageMetricRecordValue.EventType value) {
        if (this.eventType == value) {
            return this;
        }
        return new ImmutableUsageMetricRecordValue(this.intervalType, value, this.startTime, this.endTime, this.resetTime, this.counterValues, this.setValues);
    }

    public final ImmutableUsageMetricRecordValue withStartTime(long value) {
        if (this.startTime == value) {
            return this;
        }
        return new ImmutableUsageMetricRecordValue(this.intervalType, this.eventType, value, this.endTime, this.resetTime, this.counterValues, this.setValues);
    }

    public final ImmutableUsageMetricRecordValue withEndTime(long value) {
        if (this.endTime == value) {
            return this;
        }
        return new ImmutableUsageMetricRecordValue(this.intervalType, this.eventType, this.startTime, value, this.resetTime, this.counterValues, this.setValues);
    }

    public final ImmutableUsageMetricRecordValue withResetTime(long value) {
        if (this.resetTime == value) {
            return this;
        }
        return new ImmutableUsageMetricRecordValue(this.intervalType, this.eventType, this.startTime, this.endTime, value, this.counterValues, this.setValues);
    }

    public final ImmutableUsageMetricRecordValue withCounterValues(Map<String, ? extends Long> entries) {
        if (this.counterValues == entries) {
            return this;
        }
        Map<String, Long> newValue = ImmutableUsageMetricRecordValue.createUnmodifiableMap(false, false, entries);
        return new ImmutableUsageMetricRecordValue(this.intervalType, this.eventType, this.startTime, this.endTime, this.resetTime, newValue, this.setValues);
    }

    public final ImmutableUsageMetricRecordValue withSetValues(Map<String, ? extends Set<Long>> entries) {
        if (this.setValues == entries) {
            return this;
        }
        Map<String, Set<Long>> newValue = ImmutableUsageMetricRecordValue.createUnmodifiableMap(false, false, entries);
        return new ImmutableUsageMetricRecordValue(this.intervalType, this.eventType, this.startTime, this.endTime, this.resetTime, this.counterValues, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUsageMetricRecordValue && this.equalTo(0, (ImmutableUsageMetricRecordValue)another);
    }

    private boolean equalTo(int synthetic, ImmutableUsageMetricRecordValue another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return Objects.equals((Object)this.intervalType, (Object)another.intervalType) && Objects.equals((Object)this.eventType, (Object)another.eventType) && this.startTime == another.startTime && this.endTime == another.endTime && this.resetTime == another.resetTime && this.counterValues.equals(another.counterValues) && this.setValues.equals(another.setValues);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode((Object)this.intervalType);
        h += (h << 5) + Objects.hashCode((Object)this.eventType);
        h += (h << 5) + Long.hashCode(this.startTime);
        h += (h << 5) + Long.hashCode(this.endTime);
        h += (h << 5) + Long.hashCode(this.resetTime);
        h += (h << 5) + this.counterValues.hashCode();
        h += (h << 5) + this.setValues.hashCode();
        return h;
    }

    public String toString() {
        return "UsageMetricRecordValue{intervalType=" + (Object)((Object)this.intervalType) + ", eventType=" + (Object)((Object)this.eventType) + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", resetTime=" + this.resetTime + ", counterValues=" + this.counterValues + ", setValues=" + this.setValues + "}";
    }

    public static ImmutableUsageMetricRecordValue copyOf(UsageMetricRecordValue instance) {
        if (instance instanceof ImmutableUsageMetricRecordValue) {
            return (ImmutableUsageMetricRecordValue)instance;
        }
        return ImmutableUsageMetricRecordValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @ImmutableProtocol.Builder
    @Generated(from="UsageMetricRecordValue", generator="Immutables")
    public static final class Builder {
        private UsageMetricRecordValue.IntervalType intervalType;
        private UsageMetricRecordValue.EventType eventType;
        private long startTime;
        private long endTime;
        private long resetTime;
        private Map<String, Long> counterValues = new LinkedHashMap<String, Long>();
        private Map<String, Set<Long>> setValues = new LinkedHashMap<String, Set<Long>>();

        private Builder() {
        }

        public final Builder from(UsageMetricRecordValue instance) {
            UsageMetricRecordValue.EventType eventTypeValue;
            Objects.requireNonNull(instance, "instance");
            UsageMetricRecordValue.IntervalType intervalTypeValue = instance.getIntervalType();
            if (intervalTypeValue != null) {
                this.withIntervalType(intervalTypeValue);
            }
            if ((eventTypeValue = instance.getEventType()) != null) {
                this.withEventType(eventTypeValue);
            }
            this.withStartTime(instance.getStartTime());
            this.withEndTime(instance.getEndTime());
            this.withResetTime(instance.getResetTime());
            this.putAllCounterValues(instance.getCounterValues());
            this.putAllSetValues(instance.getSetValues());
            return this;
        }

        public final Builder withIntervalType(UsageMetricRecordValue.IntervalType intervalType) {
            this.intervalType = intervalType;
            return this;
        }

        public final Builder withEventType(UsageMetricRecordValue.EventType eventType) {
            this.eventType = eventType;
            return this;
        }

        public final Builder withStartTime(long startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Builder withEndTime(long endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Builder withResetTime(long resetTime) {
            this.resetTime = resetTime;
            return this;
        }

        public final Builder putCounterValue(String key, Long value) {
            this.counterValues.put(key, value);
            return this;
        }

        public final Builder putCounterValue(Map.Entry<String, ? extends Long> entry) {
            String k = entry.getKey();
            Long v = entry.getValue();
            this.counterValues.put(k, v);
            return this;
        }

        public final Builder withCounterValues(Map<String, ? extends Long> entries) {
            this.counterValues.clear();
            return this.putAllCounterValues(entries);
        }

        public final Builder putAllCounterValues(Map<String, ? extends Long> entries) {
            for (Map.Entry<String, ? extends Long> e : entries.entrySet()) {
                String k = e.getKey();
                Long v = e.getValue();
                this.counterValues.put(k, v);
            }
            return this;
        }

        public final Builder putSetValue(String key, Set<Long> value) {
            this.setValues.put(key, value);
            return this;
        }

        public final Builder putSetValue(Map.Entry<String, ? extends Set<Long>> entry) {
            String k = entry.getKey();
            Set<Long> v = entry.getValue();
            this.setValues.put(k, v);
            return this;
        }

        public final Builder withSetValues(Map<String, ? extends Set<Long>> entries) {
            this.setValues.clear();
            return this.putAllSetValues(entries);
        }

        public final Builder putAllSetValues(Map<String, ? extends Set<Long>> entries) {
            for (Map.Entry<String, ? extends Set<Long>> e : entries.entrySet()) {
                String k = e.getKey();
                Set<Long> v = e.getValue();
                this.setValues.put(k, v);
            }
            return this;
        }

        public Builder clear() {
            this.intervalType = null;
            this.eventType = null;
            this.startTime = 0L;
            this.endTime = 0L;
            this.resetTime = 0L;
            this.counterValues.clear();
            this.setValues.clear();
            return this;
        }

        public ImmutableUsageMetricRecordValue build() {
            return new ImmutableUsageMetricRecordValue(this.intervalType, this.eventType, this.startTime, this.endTime, this.resetTime, ImmutableUsageMetricRecordValue.createUnmodifiableMap(false, false, this.counterValues), ImmutableUsageMetricRecordValue.createUnmodifiableMap(false, false, this.setValues));
        }
    }
}

