/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.v870.record;

public enum ErrorCode {
    INTERNAL_ERROR(0),
    PARTITION_LEADER_MISMATCH(1),
    UNSUPPORTED_MESSAGE(2),
    INVALID_CLIENT_VERSION(3),
    MALFORMED_REQUEST(4),
    INVALID_MESSAGE_TEMPLATE(5),
    INVALID_DEPLOYMENT_PARTITION(6),
    PROCESS_NOT_FOUND(7),
    RESOURCE_EXHAUSTED(8),
    PARTITION_UNAVAILABLE(9),
    SBE_UNKNOWN(255),
    NULL_VAL(255);

    private final short value;

    private ErrorCode(short value) {
        this.value = value;
    }

    public short value() {
        return this.value;
    }

    public static ErrorCode get(short value) {
        switch (value) {
            case 0: {
                return INTERNAL_ERROR;
            }
            case 1: {
                return PARTITION_LEADER_MISMATCH;
            }
            case 2: {
                return UNSUPPORTED_MESSAGE;
            }
            case 3: {
                return INVALID_CLIENT_VERSION;
            }
            case 4: {
                return MALFORMED_REQUEST;
            }
            case 5: {
                return INVALID_MESSAGE_TEMPLATE;
            }
            case 6: {
                return INVALID_DEPLOYMENT_PARTITION;
            }
            case 7: {
                return PROCESS_NOT_FOUND;
            }
            case 8: {
                return RESOURCE_EXHAUSTED;
            }
            case 9: {
                return PARTITION_UNAVAILABLE;
            }
            case 255: {
                return NULL_VAL;
            }
        }
        return SBE_UNKNOWN;
    }
}

