/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.zeebeimport.v870.processors.os;

import io.camunda.tasklist.CommonUtils;
import io.camunda.tasklist.data.conditionals.OpenSearchCondition;
import io.camunda.tasklist.exceptions.PersistenceException;
import io.camunda.tasklist.property.TasklistProperties;
import io.camunda.tasklist.zeebeimport.v870.record.Intent;
import io.camunda.tasklist.zeebeimport.v870.record.value.VariableRecordValueImpl;
import io.camunda.webapps.schema.descriptors.template.VariableTemplate;
import io.camunda.webapps.schema.entities.VariableEntity;
import io.camunda.webapps.schema.entities.listview.VariableForListViewEntity;
import io.camunda.zeebe.protocol.v870.record.Record;
import java.util.HashMap;
import java.util.List;
import org.opensearch.client.opensearch.core.bulk.BulkOperation;
import org.opensearch.client.opensearch.core.bulk.UpdateOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class VariableZeebeRecordProcessorOpenSearch {
    private static final Logger LOGGER = LoggerFactory.getLogger(VariableZeebeRecordProcessorOpenSearch.class);
    @Autowired
    @Qualifier(value="tasklistVariableTemplate")
    private VariableTemplate variableIndex;
    @Autowired
    private TasklistProperties tasklistProperties;

    public void processVariableRecord(Record record, List<BulkOperation> operations) throws PersistenceException {
        VariableRecordValueImpl recordValue = (VariableRecordValueImpl)record.getValue();
        if (record.getIntent().name() != Intent.MIGRATED.name()) {
            operations.add(this.persistVariable(record, recordValue));
        }
    }

    private BulkOperation persistVariable(Record record, VariableRecordValueImpl recordValue) throws PersistenceException {
        VariableEntity entity = this.getVariableEntity(record, recordValue);
        return this.getVariableQuery(entity);
    }

    private BulkOperation getVariableQuery(VariableEntity entity) throws PersistenceException {
        LOGGER.debug("Variable instance for list view: id {}", (Object)entity.getId());
        HashMap<String, Object> updateFields = new HashMap<String, Object>();
        updateFields.put("value", entity.getValue());
        updateFields.put("fullValue", entity.getFullValue());
        updateFields.put("isPreview", entity.getIsPreview());
        return (BulkOperation)new BulkOperation.Builder().update(up -> ((UpdateOperation.Builder)((UpdateOperation.Builder)up.index(this.variableIndex.getFullQualifiedName())).id(entity.getId())).document((Object)CommonUtils.getJsonObjectFromEntity((Object)updateFields)).upsert((Object)CommonUtils.getJsonObjectFromEntity((Object)entity)).retryOnConflict(Integer.valueOf(3))).build();
    }

    private VariableEntity getVariableEntity(Record record, VariableRecordValueImpl recordValue) {
        VariableEntity entity = new VariableEntity().setId(String.format("%d-%s", recordValue.getScopeKey(), recordValue.getName())).setId(VariableForListViewEntity.getIdBy((long)recordValue.getScopeKey(), (String)recordValue.getName())).setKey(record.getKey()).setPartitionId(record.getPartitionId()).setScopeKey(Long.valueOf(recordValue.getScopeKey())).setProcessInstanceKey(Long.valueOf(recordValue.getProcessInstanceKey())).setProcessDefinitionKey(Long.valueOf(recordValue.getProcessDefinitionKey())).setBpmnProcessId(recordValue.getBpmnProcessId()).setName(recordValue.getName()).setTenantId(recordValue.getTenantId()).setPosition(Long.valueOf(record.getPosition()));
        int variableSizeThreshold = this.tasklistProperties.getImporter().getVariableSizeThreshold();
        if (recordValue.getValue().length() > variableSizeThreshold) {
            entity.setValue(recordValue.getValue().substring(0, variableSizeThreshold));
            entity.setFullValue(recordValue.getValue());
            entity.setIsPreview(true);
        } else {
            entity.setValue(recordValue.getValue());
            entity.setFullValue(null);
            entity.setIsPreview(false);
        }
        return entity;
    }
}

