/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.v870.record.intent;

import io.camunda.zeebe.protocol.v870.record.intent.Intent;
import io.camunda.zeebe.protocol.v870.record.intent.ProcessInstanceRelatedIntent;

public enum JobIntent implements ProcessInstanceRelatedIntent
{
    CREATED(0),
    COMPLETE(1, false),
    COMPLETED(2),
    TIME_OUT(3),
    TIMED_OUT(4),
    FAIL(5, false),
    FAILED(6),
    UPDATE_RETRIES(7, false),
    RETRIES_UPDATED(8),
    CANCEL(9),
    CANCELED(10),
    THROW_ERROR(11, false),
    ERROR_THROWN(12),
    RECUR_AFTER_BACKOFF(13),
    RECURRED_AFTER_BACKOFF(14),
    YIELD(15),
    YIELDED(16),
    UPDATE_TIMEOUT(17),
    TIMEOUT_UPDATED(18),
    MIGRATED(19),
    UPDATE(20),
    UPDATED(21);

    private final short value;
    private final boolean shouldBanInstance;

    private JobIntent(short value) {
        this(value, true);
    }

    private JobIntent(short value, boolean shouldBanInstance) {
        this.value = value;
        this.shouldBanInstance = shouldBanInstance;
    }

    public short getIntent() {
        return this.value;
    }

    public static Intent from(short value) {
        switch (value) {
            case 0: {
                return CREATED;
            }
            case 1: {
                return COMPLETE;
            }
            case 2: {
                return COMPLETED;
            }
            case 3: {
                return TIME_OUT;
            }
            case 4: {
                return TIMED_OUT;
            }
            case 5: {
                return FAIL;
            }
            case 6: {
                return FAILED;
            }
            case 7: {
                return UPDATE_RETRIES;
            }
            case 8: {
                return RETRIES_UPDATED;
            }
            case 9: {
                return CANCEL;
            }
            case 10: {
                return CANCELED;
            }
            case 11: {
                return THROW_ERROR;
            }
            case 12: {
                return ERROR_THROWN;
            }
            case 13: {
                return RECUR_AFTER_BACKOFF;
            }
            case 14: {
                return RECURRED_AFTER_BACKOFF;
            }
            case 15: {
                return YIELD;
            }
            case 16: {
                return YIELDED;
            }
            case 17: {
                return UPDATE_TIMEOUT;
            }
            case 18: {
                return TIMEOUT_UPDATED;
            }
            case 19: {
                return MIGRATED;
            }
            case 20: {
                return UPDATE;
            }
            case 21: {
                return UPDATED;
            }
        }
        return UNKNOWN;
    }

    @Override
    public short value() {
        return this.value;
    }

    @Override
    public boolean isEvent() {
        switch (this.ordinal()) {
            case 0: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 21: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean shouldBanInstanceOnError() {
        return this.shouldBanInstance;
    }
}

