/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.zeebeimport.v870.processors.os;

import io.camunda.tasklist.CommonUtils;
import io.camunda.tasklist.data.conditionals.OpenSearchCondition;
import io.camunda.tasklist.exceptions.PersistenceException;
import io.camunda.tasklist.util.ConversionUtils;
import io.camunda.tasklist.zeebeimport.v870.record.value.ProcessInstanceRecordValueImpl;
import io.camunda.webapps.schema.descriptors.template.FlowNodeInstanceTemplate;
import io.camunda.webapps.schema.entities.flownode.FlowNodeInstanceEntity;
import io.camunda.webapps.schema.entities.flownode.FlowNodeState;
import io.camunda.webapps.schema.entities.flownode.FlowNodeType;
import io.camunda.zeebe.protocol.v870.record.Record;
import io.camunda.zeebe.protocol.v870.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.v870.record.value.BpmnElementType;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opensearch.client.opensearch.core.bulk.BulkOperation;
import org.opensearch.client.opensearch.core.bulk.UpdateOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class ProcessInstanceZeebeRecordProcessorOpenSearch {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessInstanceZeebeRecordProcessorOpenSearch.class);
    private static final Set<String> FLOW_NODE_STATES = new HashSet<String>();
    private static final List<BpmnElementType> VARIABLE_SCOPE_TYPES = Arrays.asList(BpmnElementType.SUB_PROCESS, BpmnElementType.EVENT_SUB_PROCESS, BpmnElementType.USER_TASK, BpmnElementType.MULTI_INSTANCE_BODY, BpmnElementType.AD_HOC_SUB_PROCESS);
    @Autowired
    @Qualifier(value="tasklistFlowNodeInstanceTemplate")
    private FlowNodeInstanceTemplate flowNodeInstanceIndex;

    public void processProcessInstanceRecord(Record record, List<BulkOperation> operations) throws PersistenceException {
        ProcessInstanceRecordValueImpl recordValue = (ProcessInstanceRecordValueImpl)record.getValue();
        if (this.isVariableScopeType(recordValue) && FLOW_NODE_STATES.contains(record.getIntent().name())) {
            FlowNodeInstanceEntity flowNodeInstance = this.createFlowNodeInstance(record);
            operations.add(this.getFlowNodeInstanceQuery(flowNodeInstance));
        }
    }

    private FlowNodeInstanceEntity createFlowNodeInstance(Record record) {
        ProcessInstanceRecordValueImpl recordValue = (ProcessInstanceRecordValueImpl)record.getValue();
        FlowNodeInstanceEntity entity = new FlowNodeInstanceEntity();
        entity.setId(ConversionUtils.toStringOrNull((Object)record.getKey()));
        entity.setKey(record.getKey());
        entity.setPartitionId(record.getPartitionId());
        entity.setProcessInstanceKey(Long.valueOf(recordValue.getProcessInstanceKey()));
        entity.setScopeKey(Long.valueOf(recordValue.getFlowScopeKey()));
        entity.setState(FlowNodeState.ACTIVE);
        entity.setType(FlowNodeType.fromZeebeBpmnElementType(recordValue.getBpmnElementType() == null ? null : recordValue.getBpmnElementType().name()));
        entity.setPosition(Long.valueOf(record.getPosition()));
        return entity;
    }

    private BulkOperation getFlowNodeInstanceQuery(FlowNodeInstanceEntity entity) {
        LOGGER.debug("Flow node instance: id {}", (Object)entity.getId());
        return (BulkOperation)new BulkOperation.Builder().update(UpdateOperation.of(io -> ((UpdateOperation.Builder)((UpdateOperation.Builder)io.index(this.flowNodeInstanceIndex.getFullQualifiedName())).id(entity.getId())).upsert((Object)CommonUtils.getJsonObjectFromEntity((Object)entity)).document((Object)CommonUtils.getJsonObjectFromEntity(Map.of("key", entity.getKey()))))).build();
    }

    private boolean isVariableScopeType(ProcessInstanceRecordValueImpl recordValue) {
        BpmnElementType bpmnElementType = recordValue.getBpmnElementType();
        if (bpmnElementType == null) {
            return false;
        }
        return VARIABLE_SCOPE_TYPES.contains((Object)bpmnElementType);
    }

    static {
        FLOW_NODE_STATES.add(ProcessInstanceIntent.ELEMENT_ACTIVATING.name());
    }
}

