/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.v870.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.v870.record.ImmutableProtocol;
import io.camunda.zeebe.protocol.v870.record.RecordValueWithVariables;
import io.camunda.zeebe.protocol.v870.record.value.MessageRecordValue;
import io.camunda.zeebe.protocol.v870.record.value.TenantOwned;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

@ImmutableProtocol.Type(builder=Builder.class)
@Generated(from="MessageRecordValue", generator="Immutables")
@SuppressFBWarnings
public final class ImmutableMessageRecordValue
implements MessageRecordValue {
    private final Map<String, Object> variables;
    private final String tenantId;
    private final String name;
    private final String correlationKey;
    private final String messageId;
    private final long timeToLive;
    private final long deadline;
    private transient int hashCode;

    private ImmutableMessageRecordValue(Map<String, Object> variables, String tenantId, String name, String correlationKey, String messageId, long timeToLive, long deadline) {
        this.variables = variables;
        this.tenantId = tenantId;
        this.name = name;
        this.correlationKey = correlationKey;
        this.messageId = messageId;
        this.timeToLive = timeToLive;
        this.deadline = deadline;
    }

    @Override
    public Map<String, Object> getVariables() {
        return this.variables;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getCorrelationKey() {
        return this.correlationKey;
    }

    @Override
    public String getMessageId() {
        return this.messageId;
    }

    @Override
    public long getTimeToLive() {
        return this.timeToLive;
    }

    @Override
    public long getDeadline() {
        return this.deadline;
    }

    public final ImmutableMessageRecordValue withVariables(Map<String, ? extends Object> entries) {
        if (this.variables == entries) {
            return this;
        }
        Map<String, Object> newValue = ImmutableMessageRecordValue.createUnmodifiableMap(false, false, entries);
        return new ImmutableMessageRecordValue(newValue, this.tenantId, this.name, this.correlationKey, this.messageId, this.timeToLive, this.deadline);
    }

    public final ImmutableMessageRecordValue withTenantId(String value) {
        if (Objects.equals(this.tenantId, value)) {
            return this;
        }
        return new ImmutableMessageRecordValue(this.variables, value, this.name, this.correlationKey, this.messageId, this.timeToLive, this.deadline);
    }

    public final ImmutableMessageRecordValue withName(String value) {
        if (Objects.equals(this.name, value)) {
            return this;
        }
        return new ImmutableMessageRecordValue(this.variables, this.tenantId, value, this.correlationKey, this.messageId, this.timeToLive, this.deadline);
    }

    public final ImmutableMessageRecordValue withCorrelationKey(String value) {
        if (Objects.equals(this.correlationKey, value)) {
            return this;
        }
        return new ImmutableMessageRecordValue(this.variables, this.tenantId, this.name, value, this.messageId, this.timeToLive, this.deadline);
    }

    public final ImmutableMessageRecordValue withMessageId(String value) {
        if (Objects.equals(this.messageId, value)) {
            return this;
        }
        return new ImmutableMessageRecordValue(this.variables, this.tenantId, this.name, this.correlationKey, value, this.timeToLive, this.deadline);
    }

    public final ImmutableMessageRecordValue withTimeToLive(long value) {
        if (this.timeToLive == value) {
            return this;
        }
        return new ImmutableMessageRecordValue(this.variables, this.tenantId, this.name, this.correlationKey, this.messageId, value, this.deadline);
    }

    public final ImmutableMessageRecordValue withDeadline(long value) {
        if (this.deadline == value) {
            return this;
        }
        return new ImmutableMessageRecordValue(this.variables, this.tenantId, this.name, this.correlationKey, this.messageId, this.timeToLive, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageRecordValue && this.equalTo(0, (ImmutableMessageRecordValue)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageRecordValue another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.variables.equals(another.variables) && Objects.equals(this.tenantId, another.tenantId) && Objects.equals(this.name, another.name) && Objects.equals(this.correlationKey, another.correlationKey) && Objects.equals(this.messageId, another.messageId) && this.timeToLive == another.timeToLive && this.deadline == another.deadline;
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.variables.hashCode();
        h += (h << 5) + Objects.hashCode(this.tenantId);
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.correlationKey);
        h += (h << 5) + Objects.hashCode(this.messageId);
        h += (h << 5) + Long.hashCode(this.timeToLive);
        h += (h << 5) + Long.hashCode(this.deadline);
        return h;
    }

    public String toString() {
        return "MessageRecordValue{variables=" + this.variables + ", tenantId=" + this.tenantId + ", name=" + this.name + ", correlationKey=" + this.correlationKey + ", messageId=" + this.messageId + ", timeToLive=" + this.timeToLive + ", deadline=" + this.deadline + "}";
    }

    public static ImmutableMessageRecordValue copyOf(MessageRecordValue instance) {
        if (instance instanceof ImmutableMessageRecordValue) {
            return (ImmutableMessageRecordValue)instance;
        }
        return ImmutableMessageRecordValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @ImmutableProtocol.Builder
    @Generated(from="MessageRecordValue", generator="Immutables")
    public static final class Builder {
        private Map<String, Object> variables = new LinkedHashMap<String, Object>();
        private String tenantId;
        private String name;
        private String correlationKey;
        private String messageId;
        private long timeToLive;
        private long deadline;

        private Builder() {
        }

        public final Builder from(TenantOwned instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(MessageRecordValue instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(RecordValueWithVariables instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            String tenantIdValue;
            Object instance;
            long bits = 0L;
            if (object instanceof TenantOwned) {
                instance = (TenantOwned)object;
                if ((bits & 2L) == 0L) {
                    tenantIdValue = instance.getTenantId();
                    if (tenantIdValue != null) {
                        this.withTenantId(tenantIdValue);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof MessageRecordValue) {
                String correlationKeyValue;
                String messageIdValue;
                String nameValue;
                instance = (MessageRecordValue)object;
                this.withTimeToLive(instance.getTimeToLive());
                if ((bits & 1L) == 0L) {
                    this.putAllVariables(instance.getVariables());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    tenantIdValue = instance.getTenantId();
                    if (tenantIdValue != null) {
                        this.withTenantId(tenantIdValue);
                    }
                    bits |= 2L;
                }
                if ((nameValue = instance.getName()) != null) {
                    this.withName(nameValue);
                }
                if ((messageIdValue = instance.getMessageId()) != null) {
                    this.withMessageId(messageIdValue);
                }
                if ((correlationKeyValue = instance.getCorrelationKey()) != null) {
                    this.withCorrelationKey(correlationKeyValue);
                }
                this.withDeadline(instance.getDeadline());
            }
            if (object instanceof RecordValueWithVariables) {
                instance = (RecordValueWithVariables)object;
                if ((bits & 1L) == 0L) {
                    this.putAllVariables(instance.getVariables());
                    bits |= 1L;
                }
            }
        }

        public final Builder putVariable(String key, Object value) {
            this.variables.put(key, value);
            return this;
        }

        public final Builder putVariable(Map.Entry<String, ? extends Object> entry) {
            String k = entry.getKey();
            Object v = entry.getValue();
            this.variables.put(k, v);
            return this;
        }

        public final Builder withVariables(Map<String, ? extends Object> entries) {
            this.variables.clear();
            return this.putAllVariables(entries);
        }

        public final Builder putAllVariables(Map<String, ? extends Object> entries) {
            for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
                String k = e.getKey();
                Object v = e.getValue();
                this.variables.put(k, v);
            }
            return this;
        }

        public final Builder withTenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public final Builder withName(String name) {
            this.name = name;
            return this;
        }

        public final Builder withCorrelationKey(String correlationKey) {
            this.correlationKey = correlationKey;
            return this;
        }

        public final Builder withMessageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public final Builder withTimeToLive(long timeToLive) {
            this.timeToLive = timeToLive;
            return this;
        }

        public final Builder withDeadline(long deadline) {
            this.deadline = deadline;
            return this;
        }

        public Builder clear() {
            this.variables.clear();
            this.tenantId = null;
            this.name = null;
            this.correlationKey = null;
            this.messageId = null;
            this.timeToLive = 0L;
            this.deadline = 0L;
            return this;
        }

        public ImmutableMessageRecordValue build() {
            return new ImmutableMessageRecordValue(ImmutableMessageRecordValue.createUnmodifiableMap(false, false, this.variables), this.tenantId, this.name, this.correlationKey, this.messageId, this.timeToLive, this.deadline);
        }
    }
}

