/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.zeebeimport.v870.processors.es;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.tasklist.exceptions.PersistenceException;
import io.camunda.tasklist.property.TasklistProperties;
import io.camunda.tasklist.zeebeimport.v870.record.Intent;
import io.camunda.tasklist.zeebeimport.v870.record.value.VariableRecordValueImpl;
import io.camunda.webapps.schema.descriptors.template.VariableTemplate;
import io.camunda.webapps.schema.entities.VariableEntity;
import io.camunda.webapps.schema.entities.listview.VariableForListViewEntity;
import io.camunda.zeebe.protocol.v870.record.Record;
import java.io.IOException;
import java.util.HashMap;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class VariableZeebeRecordProcessorElasticSearch {
    private static final Logger LOGGER = LoggerFactory.getLogger(VariableZeebeRecordProcessorElasticSearch.class);
    @Autowired
    @Qualifier(value="tasklistObjectMapper")
    private ObjectMapper objectMapper;
    @Autowired
    @Qualifier(value="tasklistVariableTemplate")
    private VariableTemplate variableIndex;
    @Autowired
    private TasklistProperties tasklistProperties;

    public void processVariableRecord(Record record, BulkRequest bulkRequest) throws PersistenceException {
        VariableRecordValueImpl recordValue = (VariableRecordValueImpl)record.getValue();
        if (record.getIntent().name() != Intent.MIGRATED.name()) {
            bulkRequest.add(this.persistVariable(record, recordValue));
        }
    }

    private UpdateRequest persistVariable(Record record, VariableRecordValueImpl recordValue) throws PersistenceException {
        VariableEntity variableEntity = this.getVariableEntity(record, recordValue);
        return this.getVariableQuery(variableEntity);
    }

    private UpdateRequest getVariableQuery(VariableEntity entity) throws PersistenceException {
        try {
            LOGGER.debug("Variable instance for list view: id {}", (Object)entity.getId());
            HashMap<String, Object> updateFields = new HashMap<String, Object>();
            updateFields.put("value", entity.getValue());
            updateFields.put("fullValue", entity.getFullValue());
            updateFields.put("isPreview", entity.getIsPreview());
            return ((UpdateRequest)new UpdateRequest().index(this.variableIndex.getFullQualifiedName())).id(entity.getId()).upsert(this.objectMapper.writeValueAsString((Object)entity), XContentType.JSON).doc(updateFields).retryOnConflict(3);
        }
        catch (IOException e) {
            throw new PersistenceException(String.format("Error preparing the query to upsert variable instance [%s]  for list view", entity.getId()), (Throwable)e);
        }
    }

    private VariableEntity getVariableEntity(Record record, VariableRecordValueImpl recordValue) {
        VariableEntity entity = new VariableEntity().setId(String.format("%d-%s", recordValue.getScopeKey(), recordValue.getName())).setId(VariableForListViewEntity.getIdBy((long)recordValue.getScopeKey(), (String)recordValue.getName())).setKey(record.getKey()).setPartitionId(record.getPartitionId()).setScopeKey(Long.valueOf(recordValue.getScopeKey())).setProcessInstanceKey(Long.valueOf(recordValue.getProcessInstanceKey())).setProcessDefinitionKey(Long.valueOf(recordValue.getProcessDefinitionKey())).setBpmnProcessId(recordValue.getBpmnProcessId()).setName(recordValue.getName()).setTenantId(recordValue.getTenantId()).setPosition(Long.valueOf(record.getPosition()));
        int variableSizeThreshold = this.tasklistProperties.getImporter().getVariableSizeThreshold();
        if (recordValue.getValue().length() > variableSizeThreshold) {
            entity.setValue(recordValue.getValue().substring(0, variableSizeThreshold));
            entity.setFullValue(recordValue.getValue());
            entity.setIsPreview(true);
        } else {
            entity.setValue(recordValue.getValue());
            entity.setFullValue(null);
            entity.setIsPreview(false);
        }
        return entity;
    }
}

