/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.zeebeimport.v870.processors.common;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import io.camunda.tasklist.property.TasklistProperties;
import io.camunda.tasklist.zeebeimport.v870.processors.common.UserTaskRecordToTaskEntityMapper;
import io.camunda.tasklist.zeebeimport.v870.record.Intent;
import io.camunda.webapps.schema.entities.usertask.SnapshotTaskVariableEntity;
import io.camunda.zeebe.protocol.v870.record.Record;
import io.camunda.zeebe.protocol.v870.record.value.UserTaskRecordValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class UserTaskRecordToVariableEntityMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserTaskRecordToTaskEntityMapper.class);
    @Autowired
    private TasklistProperties tasklistProperties;
    @Autowired
    @Qualifier(value="tasklistObjectMapper")
    private ObjectMapper objectMapper;

    public List<SnapshotTaskVariableEntity> mapVariables(Record<UserTaskRecordValue> record) {
        ArrayList<SnapshotTaskVariableEntity> variables = new ArrayList<SnapshotTaskVariableEntity>();
        if (record.getIntent().equals(Intent.COMPLETED)) {
            UserTaskRecordValue recordValue = record.getValue();
            Map<String, Object> variablesMap = recordValue.getVariables();
            for (Map.Entry<String, Object> varMap : variablesMap.entrySet()) {
                String varValue;
                try {
                    varValue = this.objectMapper.writeValueAsString(varMap.getValue());
                }
                catch (JsonProcessingException e) {
                    throw new TasklistRuntimeException("Failed to parse variable %s".formatted(varMap), (Throwable)e);
                }
                SnapshotTaskVariableEntity variableEntity = new SnapshotTaskVariableEntity();
                variableEntity.setId(String.format("%s-%s", String.valueOf(recordValue.getUserTaskKey()), varMap.getKey()));
                variableEntity.setName(varMap.getKey());
                variableEntity.setTaskId(String.valueOf(recordValue.getUserTaskKey()));
                variableEntity.setProcessInstanceKey(Long.valueOf(recordValue.getProcessInstanceKey()));
                variableEntity.setPartitionId(record.getPartitionId());
                variableEntity.setTenantId(recordValue.getTenantId());
                variableEntity.setFullValue(varValue);
                if (varValue.length() > this.tasklistProperties.getImporter().getVariableSizeThreshold()) {
                    variableEntity.setValue(varValue.substring(0, this.tasklistProperties.getImporter().getVariableSizeThreshold()));
                    variableEntity.setIsPreview(true);
                } else {
                    variableEntity.setValue(varValue);
                }
                variables.add(variableEntity);
            }
        }
        return variables;
    }
}

