/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.v870.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.v870.record.ImmutableProtocol;
import io.camunda.zeebe.protocol.v870.record.value.EntityType;
import io.camunda.zeebe.protocol.v870.record.value.RoleRecordValue;
import java.util.Objects;
import org.immutables.value.Generated;

@ImmutableProtocol.Type(builder=Builder.class)
@Generated(from="RoleRecordValue", generator="Immutables")
@SuppressFBWarnings
public final class ImmutableRoleRecordValue
implements RoleRecordValue {
    private final long roleKey;
    private final String roleId;
    private final String name;
    private final String description;
    private final long entityKey;
    private final String entityId;
    private final EntityType entityType;
    private transient int hashCode;

    private ImmutableRoleRecordValue(long roleKey, String roleId, String name, String description, long entityKey, String entityId, EntityType entityType) {
        this.roleKey = roleKey;
        this.roleId = roleId;
        this.name = name;
        this.description = description;
        this.entityKey = entityKey;
        this.entityId = entityId;
        this.entityType = entityType;
    }

    @Override
    public long getRoleKey() {
        return this.roleKey;
    }

    @Override
    public String getRoleId() {
        return this.roleId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public long getEntityKey() {
        return this.entityKey;
    }

    @Override
    public String getEntityId() {
        return this.entityId;
    }

    @Override
    public EntityType getEntityType() {
        return this.entityType;
    }

    public final ImmutableRoleRecordValue withRoleKey(long value) {
        if (this.roleKey == value) {
            return this;
        }
        return new ImmutableRoleRecordValue(value, this.roleId, this.name, this.description, this.entityKey, this.entityId, this.entityType);
    }

    public final ImmutableRoleRecordValue withRoleId(String value) {
        if (Objects.equals(this.roleId, value)) {
            return this;
        }
        return new ImmutableRoleRecordValue(this.roleKey, value, this.name, this.description, this.entityKey, this.entityId, this.entityType);
    }

    public final ImmutableRoleRecordValue withName(String value) {
        if (Objects.equals(this.name, value)) {
            return this;
        }
        return new ImmutableRoleRecordValue(this.roleKey, this.roleId, value, this.description, this.entityKey, this.entityId, this.entityType);
    }

    public final ImmutableRoleRecordValue withDescription(String value) {
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutableRoleRecordValue(this.roleKey, this.roleId, this.name, value, this.entityKey, this.entityId, this.entityType);
    }

    public final ImmutableRoleRecordValue withEntityKey(long value) {
        if (this.entityKey == value) {
            return this;
        }
        return new ImmutableRoleRecordValue(this.roleKey, this.roleId, this.name, this.description, value, this.entityId, this.entityType);
    }

    public final ImmutableRoleRecordValue withEntityId(String value) {
        if (Objects.equals(this.entityId, value)) {
            return this;
        }
        return new ImmutableRoleRecordValue(this.roleKey, this.roleId, this.name, this.description, this.entityKey, value, this.entityType);
    }

    public final ImmutableRoleRecordValue withEntityType(EntityType value) {
        if (this.entityType == value) {
            return this;
        }
        return new ImmutableRoleRecordValue(this.roleKey, this.roleId, this.name, this.description, this.entityKey, this.entityId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRoleRecordValue && this.equalTo(0, (ImmutableRoleRecordValue)another);
    }

    private boolean equalTo(int synthetic, ImmutableRoleRecordValue another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.roleKey == another.roleKey && Objects.equals(this.roleId, another.roleId) && Objects.equals(this.name, another.name) && Objects.equals(this.description, another.description) && this.entityKey == another.entityKey && Objects.equals(this.entityId, another.entityId) && Objects.equals((Object)this.entityType, (Object)another.entityType);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + Long.hashCode(this.roleKey);
        h += (h << 5) + Objects.hashCode(this.roleId);
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + Long.hashCode(this.entityKey);
        h += (h << 5) + Objects.hashCode(this.entityId);
        h += (h << 5) + Objects.hashCode((Object)this.entityType);
        return h;
    }

    public String toString() {
        return "RoleRecordValue{roleKey=" + this.roleKey + ", roleId=" + this.roleId + ", name=" + this.name + ", description=" + this.description + ", entityKey=" + this.entityKey + ", entityId=" + this.entityId + ", entityType=" + (Object)((Object)this.entityType) + "}";
    }

    public static ImmutableRoleRecordValue copyOf(RoleRecordValue instance) {
        if (instance instanceof ImmutableRoleRecordValue) {
            return (ImmutableRoleRecordValue)instance;
        }
        return ImmutableRoleRecordValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @ImmutableProtocol.Builder
    @Generated(from="RoleRecordValue", generator="Immutables")
    public static final class Builder {
        private long roleKey;
        private String roleId;
        private String name;
        private String description;
        private long entityKey;
        private String entityId;
        private EntityType entityType;

        private Builder() {
        }

        public final Builder from(RoleRecordValue instance) {
            EntityType entityTypeValue;
            String descriptionValue;
            String nameValue;
            Objects.requireNonNull(instance, "instance");
            this.withRoleKey(instance.getRoleKey());
            String roleIdValue = instance.getRoleId();
            if (roleIdValue != null) {
                this.withRoleId(roleIdValue);
            }
            if ((nameValue = instance.getName()) != null) {
                this.withName(nameValue);
            }
            if ((descriptionValue = instance.getDescription()) != null) {
                this.withDescription(descriptionValue);
            }
            this.withEntityKey(instance.getEntityKey());
            String entityIdValue = instance.getEntityId();
            if (entityIdValue != null) {
                this.withEntityId(entityIdValue);
            }
            if ((entityTypeValue = instance.getEntityType()) != null) {
                this.withEntityType(entityTypeValue);
            }
            return this;
        }

        public final Builder withRoleKey(long roleKey) {
            this.roleKey = roleKey;
            return this;
        }

        public final Builder withRoleId(String roleId) {
            this.roleId = roleId;
            return this;
        }

        public final Builder withName(String name) {
            this.name = name;
            return this;
        }

        public final Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public final Builder withEntityKey(long entityKey) {
            this.entityKey = entityKey;
            return this;
        }

        public final Builder withEntityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final Builder withEntityType(EntityType entityType) {
            this.entityType = entityType;
            return this;
        }

        public Builder clear() {
            this.roleKey = 0L;
            this.roleId = null;
            this.name = null;
            this.description = null;
            this.entityKey = 0L;
            this.entityId = null;
            this.entityType = null;
            return this;
        }

        public ImmutableRoleRecordValue build() {
            return new ImmutableRoleRecordValue(this.roleKey, this.roleId, this.name, this.description, this.entityKey, this.entityId, this.entityType);
        }
    }
}

