/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.v870.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.v870.record.ImmutableProtocol;
import io.camunda.zeebe.protocol.v870.record.value.BatchOperationChunkRecordValue;
import io.camunda.zeebe.protocol.v870.record.value.BatchOperationRelated;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.immutables.value.Generated;

@ImmutableProtocol.Type(builder=Builder.class)
@Generated(from="BatchOperationChunkRecordValue", generator="Immutables")
@SuppressFBWarnings
public final class ImmutableBatchOperationChunkRecordValue
implements BatchOperationChunkRecordValue {
    private final long batchOperationKey;
    private final Set<Long> itemKeys;
    private transient int hashCode;

    private ImmutableBatchOperationChunkRecordValue(long batchOperationKey, Set<Long> itemKeys) {
        this.batchOperationKey = batchOperationKey;
        this.itemKeys = itemKeys;
    }

    @Override
    public long getBatchOperationKey() {
        return this.batchOperationKey;
    }

    @Override
    public Set<Long> getItemKeys() {
        return this.itemKeys;
    }

    public final ImmutableBatchOperationChunkRecordValue withBatchOperationKey(long value) {
        if (this.batchOperationKey == value) {
            return this;
        }
        return new ImmutableBatchOperationChunkRecordValue(value, this.itemKeys);
    }

    public final ImmutableBatchOperationChunkRecordValue withItemKeys(Long ... elements) {
        Set<Long> newValue = ImmutableBatchOperationChunkRecordValue.createUnmodifiableSet(ImmutableBatchOperationChunkRecordValue.createSafeList(Arrays.asList(elements), false, false));
        return new ImmutableBatchOperationChunkRecordValue(this.batchOperationKey, newValue);
    }

    public final ImmutableBatchOperationChunkRecordValue withItemKeys(Iterable<? extends Long> elements) {
        if (this.itemKeys == elements) {
            return this;
        }
        Set<Long> newValue = ImmutableBatchOperationChunkRecordValue.createUnmodifiableSet(ImmutableBatchOperationChunkRecordValue.createSafeList(elements, false, false));
        return new ImmutableBatchOperationChunkRecordValue(this.batchOperationKey, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBatchOperationChunkRecordValue && this.equalTo(0, (ImmutableBatchOperationChunkRecordValue)another);
    }

    private boolean equalTo(int synthetic, ImmutableBatchOperationChunkRecordValue another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.batchOperationKey == another.batchOperationKey && this.itemKeys.equals(another.itemKeys);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + Long.hashCode(this.batchOperationKey);
        h += (h << 5) + this.itemKeys.hashCode();
        return h;
    }

    public String toString() {
        return "BatchOperationChunkRecordValue{batchOperationKey=" + this.batchOperationKey + ", itemKeys=" + this.itemKeys + "}";
    }

    public static ImmutableBatchOperationChunkRecordValue copyOf(BatchOperationChunkRecordValue instance) {
        if (instance instanceof ImmutableBatchOperationChunkRecordValue) {
            return (ImmutableBatchOperationChunkRecordValue)instance;
        }
        return ImmutableBatchOperationChunkRecordValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size() * 4 / 3 + 1);
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    @ImmutableProtocol.Builder
    @Generated(from="BatchOperationChunkRecordValue", generator="Immutables")
    public static final class Builder {
        private long batchOperationKey;
        private List<Long> itemKeys = new ArrayList<Long>();

        private Builder() {
        }

        public final Builder from(BatchOperationChunkRecordValue instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(BatchOperationRelated instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            BatchOperationRelated instance;
            long bits = 0L;
            if (object instanceof BatchOperationChunkRecordValue) {
                instance = (BatchOperationChunkRecordValue)object;
                this.addAllItemKeys(instance.getItemKeys());
                if ((bits & 1L) == 0L) {
                    this.withBatchOperationKey(instance.getBatchOperationKey());
                    bits |= 1L;
                }
            }
            if (object instanceof BatchOperationRelated) {
                instance = (BatchOperationRelated)object;
                if ((bits & 1L) == 0L) {
                    this.withBatchOperationKey(instance.getBatchOperationKey());
                    bits |= 1L;
                }
            }
        }

        public final Builder withBatchOperationKey(long batchOperationKey) {
            this.batchOperationKey = batchOperationKey;
            return this;
        }

        public final Builder addItemKey(Long element) {
            this.itemKeys.add(element);
            return this;
        }

        public final Builder addItemKeys(Long ... elements) {
            for (Long element : elements) {
                this.itemKeys.add(element);
            }
            return this;
        }

        public final Builder withItemKeys(Iterable<? extends Long> elements) {
            this.itemKeys.clear();
            return this.addAllItemKeys(elements);
        }

        public final Builder addAllItemKeys(Iterable<? extends Long> elements) {
            for (Long l : elements) {
                this.itemKeys.add(l);
            }
            return this;
        }

        public Builder clear() {
            this.batchOperationKey = 0L;
            this.itemKeys.clear();
            return this;
        }

        public ImmutableBatchOperationChunkRecordValue build() {
            return new ImmutableBatchOperationChunkRecordValue(this.batchOperationKey, ImmutableBatchOperationChunkRecordValue.createUnmodifiableSet(this.itemKeys));
        }
    }
}

