/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.zeebeimport.v870.processors.es;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.tasklist.exceptions.PersistenceException;
import io.camunda.tasklist.util.ConversionUtils;
import io.camunda.tasklist.zeebeimport.v870.record.value.ProcessInstanceRecordValueImpl;
import io.camunda.webapps.schema.descriptors.template.FlowNodeInstanceTemplate;
import io.camunda.webapps.schema.entities.flownode.FlowNodeInstanceEntity;
import io.camunda.webapps.schema.entities.flownode.FlowNodeState;
import io.camunda.webapps.schema.entities.flownode.FlowNodeType;
import io.camunda.zeebe.protocol.v870.record.Record;
import io.camunda.zeebe.protocol.v870.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.v870.record.value.BpmnElementType;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class ProcessInstanceZeebeRecordProcessorElasticSearch {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessInstanceZeebeRecordProcessorElasticSearch.class);
    private static final Set<String> FLOW_NODE_STATES = new HashSet<String>();
    private static final List<BpmnElementType> VARIABLE_SCOPE_TYPES = Arrays.asList(BpmnElementType.SUB_PROCESS, BpmnElementType.EVENT_SUB_PROCESS, BpmnElementType.USER_TASK, BpmnElementType.MULTI_INSTANCE_BODY, BpmnElementType.AD_HOC_SUB_PROCESS);
    @Autowired
    @Qualifier(value="tasklistObjectMapper")
    private ObjectMapper objectMapper;
    @Autowired
    @Qualifier(value="tasklistFlowNodeInstanceTemplate")
    private FlowNodeInstanceTemplate flowNodeInstanceIndex;

    public void processProcessInstanceRecord(Record record, BulkRequest bulkRequest) throws PersistenceException {
        ProcessInstanceRecordValueImpl recordValue = (ProcessInstanceRecordValueImpl)record.getValue();
        if (this.isVariableScopeType(recordValue) && FLOW_NODE_STATES.contains(record.getIntent().name())) {
            FlowNodeInstanceEntity flowNodeInstance = this.createFlowNodeInstance(record);
            bulkRequest.add(this.getFlowNodeInstanceQuery(flowNodeInstance));
        }
    }

    private FlowNodeInstanceEntity createFlowNodeInstance(Record record) {
        ProcessInstanceRecordValueImpl recordValue = (ProcessInstanceRecordValueImpl)record.getValue();
        FlowNodeInstanceEntity entity = new FlowNodeInstanceEntity();
        entity.setId(ConversionUtils.toStringOrNull((Object)record.getKey()));
        entity.setKey(record.getKey());
        entity.setPartitionId(record.getPartitionId());
        entity.setProcessInstanceKey(Long.valueOf(recordValue.getProcessInstanceKey()));
        entity.setScopeKey(Long.valueOf(recordValue.getFlowScopeKey()));
        entity.setState(FlowNodeState.ACTIVE);
        entity.setType(FlowNodeType.fromZeebeBpmnElementType(recordValue.getBpmnElementType() == null ? null : recordValue.getBpmnElementType().name()));
        entity.setPosition(Long.valueOf(record.getPosition()));
        return entity;
    }

    private UpdateRequest getFlowNodeInstanceQuery(FlowNodeInstanceEntity entity) throws PersistenceException {
        try {
            LOGGER.debug("Flow node instance: id {}", (Object)entity.getId());
            return new UpdateRequest(this.flowNodeInstanceIndex.getFullQualifiedName(), entity.getId()).upsert(this.objectMapper.writeValueAsString((Object)entity), XContentType.JSON).doc(Map.of("key", entity.getKey()));
        }
        catch (IOException e) {
            throw new PersistenceException(String.format("Error preparing the query to index flow node instance [%s]", entity.getId()), (Throwable)e);
        }
    }

    private boolean isVariableScopeType(ProcessInstanceRecordValueImpl recordValue) {
        BpmnElementType bpmnElementType = recordValue.getBpmnElementType();
        if (bpmnElementType == null) {
            return false;
        }
        return VARIABLE_SCOPE_TYPES.contains((Object)bpmnElementType);
    }

    static {
        FLOW_NODE_STATES.add(ProcessInstanceIntent.ELEMENT_ACTIVATING.name());
    }
}

