/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.v870.record.value.deployment;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.v870.record.ImmutableProtocol;
import io.camunda.zeebe.protocol.v870.record.value.TenantOwned;
import io.camunda.zeebe.protocol.v870.record.value.deployment.Resource;
import io.camunda.zeebe.protocol.v870.record.value.deployment.ResourceMetadataValue;
import java.util.Arrays;
import java.util.Objects;
import org.immutables.value.Generated;

@ImmutableProtocol.Type(builder=Builder.class)
@Generated(from="Resource", generator="Immutables")
@SuppressFBWarnings
public final class ImmutableResource
implements Resource {
    private final String tenantId;
    private final String resourceId;
    private final int version;
    private final String versionTag;
    private final long resourceKey;
    private final byte[] checksum;
    private final String resourceName;
    private final boolean duplicate;
    private final long deploymentKey;
    private final String resourceProp;
    private transient int hashCode;

    private ImmutableResource(String tenantId, String resourceId, int version, String versionTag, long resourceKey, byte[] checksum, String resourceName, boolean duplicate, long deploymentKey, String resourceProp) {
        this.tenantId = tenantId;
        this.resourceId = resourceId;
        this.version = version;
        this.versionTag = versionTag;
        this.resourceKey = resourceKey;
        this.checksum = checksum;
        this.resourceName = resourceName;
        this.duplicate = duplicate;
        this.deploymentKey = deploymentKey;
        this.resourceProp = resourceProp;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public String getResourceId() {
        return this.resourceId;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public String getVersionTag() {
        return this.versionTag;
    }

    @Override
    public long getResourceKey() {
        return this.resourceKey;
    }

    @Override
    public byte[] getChecksum() {
        return this.checksum;
    }

    @Override
    public String getResourceName() {
        return this.resourceName;
    }

    @Override
    public boolean isDuplicate() {
        return this.duplicate;
    }

    @Override
    public long getDeploymentKey() {
        return this.deploymentKey;
    }

    @Override
    public String getResourceProp() {
        return this.resourceProp;
    }

    public final ImmutableResource withTenantId(String value) {
        if (Objects.equals(this.tenantId, value)) {
            return this;
        }
        return new ImmutableResource(value, this.resourceId, this.version, this.versionTag, this.resourceKey, this.checksum, this.resourceName, this.duplicate, this.deploymentKey, this.resourceProp);
    }

    public final ImmutableResource withResourceId(String value) {
        if (Objects.equals(this.resourceId, value)) {
            return this;
        }
        return new ImmutableResource(this.tenantId, value, this.version, this.versionTag, this.resourceKey, this.checksum, this.resourceName, this.duplicate, this.deploymentKey, this.resourceProp);
    }

    public final ImmutableResource withVersion(int value) {
        if (this.version == value) {
            return this;
        }
        return new ImmutableResource(this.tenantId, this.resourceId, value, this.versionTag, this.resourceKey, this.checksum, this.resourceName, this.duplicate, this.deploymentKey, this.resourceProp);
    }

    public final ImmutableResource withVersionTag(String value) {
        if (Objects.equals(this.versionTag, value)) {
            return this;
        }
        return new ImmutableResource(this.tenantId, this.resourceId, this.version, value, this.resourceKey, this.checksum, this.resourceName, this.duplicate, this.deploymentKey, this.resourceProp);
    }

    public final ImmutableResource withResourceKey(long value) {
        if (this.resourceKey == value) {
            return this;
        }
        return new ImmutableResource(this.tenantId, this.resourceId, this.version, this.versionTag, value, this.checksum, this.resourceName, this.duplicate, this.deploymentKey, this.resourceProp);
    }

    public final ImmutableResource withChecksum(byte ... elements) {
        byte[] newValue = elements == null ? null : (byte[])elements.clone();
        return new ImmutableResource(this.tenantId, this.resourceId, this.version, this.versionTag, this.resourceKey, newValue, this.resourceName, this.duplicate, this.deploymentKey, this.resourceProp);
    }

    public final ImmutableResource withResourceName(String value) {
        if (Objects.equals(this.resourceName, value)) {
            return this;
        }
        return new ImmutableResource(this.tenantId, this.resourceId, this.version, this.versionTag, this.resourceKey, this.checksum, value, this.duplicate, this.deploymentKey, this.resourceProp);
    }

    public final ImmutableResource withDuplicate(boolean value) {
        if (this.duplicate == value) {
            return this;
        }
        return new ImmutableResource(this.tenantId, this.resourceId, this.version, this.versionTag, this.resourceKey, this.checksum, this.resourceName, value, this.deploymentKey, this.resourceProp);
    }

    public final ImmutableResource withDeploymentKey(long value) {
        if (this.deploymentKey == value) {
            return this;
        }
        return new ImmutableResource(this.tenantId, this.resourceId, this.version, this.versionTag, this.resourceKey, this.checksum, this.resourceName, this.duplicate, value, this.resourceProp);
    }

    public final ImmutableResource withResourceProp(String value) {
        if (Objects.equals(this.resourceProp, value)) {
            return this;
        }
        return new ImmutableResource(this.tenantId, this.resourceId, this.version, this.versionTag, this.resourceKey, this.checksum, this.resourceName, this.duplicate, this.deploymentKey, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableResource && this.equalTo(0, (ImmutableResource)another);
    }

    private boolean equalTo(int synthetic, ImmutableResource another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return Objects.equals(this.tenantId, another.tenantId) && Objects.equals(this.resourceId, another.resourceId) && this.version == another.version && Objects.equals(this.versionTag, another.versionTag) && this.resourceKey == another.resourceKey && Arrays.equals(this.checksum, another.checksum) && Objects.equals(this.resourceName, another.resourceName) && this.duplicate == another.duplicate && this.deploymentKey == another.deploymentKey && Objects.equals(this.resourceProp, another.resourceProp);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.tenantId);
        h += (h << 5) + Objects.hashCode(this.resourceId);
        h += (h << 5) + this.version;
        h += (h << 5) + Objects.hashCode(this.versionTag);
        h += (h << 5) + Long.hashCode(this.resourceKey);
        h += (h << 5) + Arrays.hashCode(this.checksum);
        h += (h << 5) + Objects.hashCode(this.resourceName);
        h += (h << 5) + Boolean.hashCode(this.duplicate);
        h += (h << 5) + Long.hashCode(this.deploymentKey);
        h += (h << 5) + Objects.hashCode(this.resourceProp);
        return h;
    }

    public String toString() {
        return "Resource{tenantId=" + this.tenantId + ", resourceId=" + this.resourceId + ", version=" + this.version + ", versionTag=" + this.versionTag + ", resourceKey=" + this.resourceKey + ", checksum=" + Arrays.toString(this.checksum) + ", resourceName=" + this.resourceName + ", duplicate=" + this.duplicate + ", deploymentKey=" + this.deploymentKey + ", resourceProp=" + this.resourceProp + "}";
    }

    public static ImmutableResource copyOf(Resource instance) {
        if (instance instanceof ImmutableResource) {
            return (ImmutableResource)instance;
        }
        return ImmutableResource.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @ImmutableProtocol.Builder
    @Generated(from="Resource", generator="Immutables")
    public static final class Builder {
        private String tenantId;
        private String resourceId;
        private int version;
        private String versionTag;
        private long resourceKey;
        private byte[] checksum;
        private String resourceName;
        private boolean duplicate;
        private long deploymentKey;
        private String resourceProp;

        private Builder() {
        }

        public final Builder from(Resource instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(ResourceMetadataValue instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(TenantOwned instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            String tenantIdValue;
            String resourceIdValue;
            TenantOwned instance;
            long bits = 0L;
            if (object instanceof Resource) {
                String resourcePropValue;
                instance = (Resource)object;
                if ((bits & 1L) == 0L) {
                    resourceIdValue = instance.getResourceId();
                    if (resourceIdValue != null) {
                        this.withResourceId(resourceIdValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.withResourceKey(instance.getResourceKey());
                    bits |= 2L;
                }
                if ((resourcePropValue = instance.getResourceProp()) != null) {
                    this.withResourceProp(resourcePropValue);
                }
                if ((bits & 0x40L) == 0L) {
                    this.withDeploymentKey(instance.getDeploymentKey());
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    String tenantIdValue2 = instance.getTenantId();
                    if (tenantIdValue2 != null) {
                        this.withTenantId(tenantIdValue2);
                    }
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    byte[] checksumValue = instance.getChecksum();
                    if (checksumValue != null) {
                        this.withChecksum(checksumValue);
                    }
                    bits |= 0x100L;
                }
                if ((bits & 4L) == 0L) {
                    String versionTagValue = instance.getVersionTag();
                    if (versionTagValue != null) {
                        this.withVersionTag(versionTagValue);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    String resourceNameValue = instance.getResourceName();
                    if (resourceNameValue != null) {
                        this.withResourceName(resourceNameValue);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.withDuplicate(instance.isDuplicate());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.withVersion(instance.getVersion());
                    bits |= 0x20L;
                }
            }
            if (object instanceof ResourceMetadataValue) {
                instance = (ResourceMetadataValue)object;
                if ((bits & 1L) == 0L) {
                    resourceIdValue = instance.getResourceId();
                    if (resourceIdValue != null) {
                        this.withResourceId(resourceIdValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.withResourceKey(instance.getResourceKey());
                    bits |= 2L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.withDeploymentKey(instance.getDeploymentKey());
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    tenantIdValue = instance.getTenantId();
                    if (tenantIdValue != null) {
                        this.withTenantId(tenantIdValue);
                    }
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    byte[] checksumValue = instance.getChecksum();
                    if (checksumValue != null) {
                        this.withChecksum(checksumValue);
                    }
                    bits |= 0x100L;
                }
                if ((bits & 4L) == 0L) {
                    String versionTagValue = instance.getVersionTag();
                    if (versionTagValue != null) {
                        this.withVersionTag(versionTagValue);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    String resourceNameValue = instance.getResourceName();
                    if (resourceNameValue != null) {
                        this.withResourceName(resourceNameValue);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.withDuplicate(instance.isDuplicate());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.withVersion(instance.getVersion());
                    bits |= 0x20L;
                }
            }
            if (object instanceof TenantOwned) {
                instance = (TenantOwned)object;
                if ((bits & 0x80L) == 0L) {
                    tenantIdValue = instance.getTenantId();
                    if (tenantIdValue != null) {
                        this.withTenantId(tenantIdValue);
                    }
                    bits |= 0x80L;
                }
            }
        }

        public final Builder withTenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public final Builder withResourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final Builder withVersion(int version) {
            this.version = version;
            return this;
        }

        public final Builder withVersionTag(String versionTag) {
            this.versionTag = versionTag;
            return this;
        }

        public final Builder withResourceKey(long resourceKey) {
            this.resourceKey = resourceKey;
            return this;
        }

        public final Builder withChecksum(byte ... checksum) {
            this.checksum = checksum;
            return this;
        }

        public final Builder withResourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final Builder withDuplicate(boolean duplicate) {
            this.duplicate = duplicate;
            return this;
        }

        public final Builder withDeploymentKey(long deploymentKey) {
            this.deploymentKey = deploymentKey;
            return this;
        }

        public final Builder withResourceProp(String resourceProp) {
            this.resourceProp = resourceProp;
            return this;
        }

        public Builder clear() {
            this.tenantId = null;
            this.resourceId = null;
            this.version = 0;
            this.versionTag = null;
            this.resourceKey = 0L;
            this.checksum = null;
            this.resourceName = null;
            this.duplicate = false;
            this.deploymentKey = 0L;
            this.resourceProp = null;
            return this;
        }

        public ImmutableResource build() {
            return new ImmutableResource(this.tenantId, this.resourceId, this.version, this.versionTag, this.resourceKey, this.checksum, this.resourceName, this.duplicate, this.deploymentKey, this.resourceProp);
        }
    }
}

