/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.v870.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.v870.record.ImmutableProtocol;
import io.camunda.zeebe.protocol.v870.record.value.EntityType;
import io.camunda.zeebe.protocol.v870.record.value.RoleRecordValue;
import java.util.Objects;
import org.immutables.value.Generated;

@ImmutableProtocol.Type(builder=Builder.class)
@Generated(from="RoleRecordValue", generator="Immutables")
@SuppressFBWarnings
public final class ImmutableRoleRecordValue
implements RoleRecordValue {
    private final long roleKey;
    private final String name;
    private final long entityKey;
    private final EntityType entityType;
    private transient int hashCode;

    private ImmutableRoleRecordValue(long roleKey, String name, long entityKey, EntityType entityType) {
        this.roleKey = roleKey;
        this.name = name;
        this.entityKey = entityKey;
        this.entityType = entityType;
    }

    @Override
    public long getRoleKey() {
        return this.roleKey;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getEntityKey() {
        return this.entityKey;
    }

    @Override
    public EntityType getEntityType() {
        return this.entityType;
    }

    public final ImmutableRoleRecordValue withRoleKey(long value) {
        if (this.roleKey == value) {
            return this;
        }
        return new ImmutableRoleRecordValue(value, this.name, this.entityKey, this.entityType);
    }

    public final ImmutableRoleRecordValue withName(String value) {
        if (Objects.equals(this.name, value)) {
            return this;
        }
        return new ImmutableRoleRecordValue(this.roleKey, value, this.entityKey, this.entityType);
    }

    public final ImmutableRoleRecordValue withEntityKey(long value) {
        if (this.entityKey == value) {
            return this;
        }
        return new ImmutableRoleRecordValue(this.roleKey, this.name, value, this.entityType);
    }

    public final ImmutableRoleRecordValue withEntityType(EntityType value) {
        if (this.entityType == value) {
            return this;
        }
        return new ImmutableRoleRecordValue(this.roleKey, this.name, this.entityKey, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRoleRecordValue && this.equalTo(0, (ImmutableRoleRecordValue)another);
    }

    private boolean equalTo(int synthetic, ImmutableRoleRecordValue another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.roleKey == another.roleKey && Objects.equals(this.name, another.name) && this.entityKey == another.entityKey && Objects.equals((Object)this.entityType, (Object)another.entityType);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + Long.hashCode(this.roleKey);
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Long.hashCode(this.entityKey);
        h += (h << 5) + Objects.hashCode((Object)this.entityType);
        return h;
    }

    public String toString() {
        return "RoleRecordValue{roleKey=" + this.roleKey + ", name=" + this.name + ", entityKey=" + this.entityKey + ", entityType=" + (Object)((Object)this.entityType) + "}";
    }

    public static ImmutableRoleRecordValue copyOf(RoleRecordValue instance) {
        if (instance instanceof ImmutableRoleRecordValue) {
            return (ImmutableRoleRecordValue)instance;
        }
        return ImmutableRoleRecordValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @ImmutableProtocol.Builder
    @Generated(from="RoleRecordValue", generator="Immutables")
    public static final class Builder {
        private long roleKey;
        private String name;
        private long entityKey;
        private EntityType entityType;

        private Builder() {
        }

        public final Builder from(RoleRecordValue instance) {
            Objects.requireNonNull(instance, "instance");
            this.withRoleKey(instance.getRoleKey());
            String nameValue = instance.getName();
            if (nameValue != null) {
                this.withName(nameValue);
            }
            this.withEntityKey(instance.getEntityKey());
            EntityType entityTypeValue = instance.getEntityType();
            if (entityTypeValue != null) {
                this.withEntityType(entityTypeValue);
            }
            return this;
        }

        public final Builder withRoleKey(long roleKey) {
            this.roleKey = roleKey;
            return this;
        }

        public final Builder withName(String name) {
            this.name = name;
            return this;
        }

        public final Builder withEntityKey(long entityKey) {
            this.entityKey = entityKey;
            return this;
        }

        public final Builder withEntityType(EntityType entityType) {
            this.entityType = entityType;
            return this;
        }

        public Builder clear() {
            this.roleKey = 0L;
            this.name = null;
            this.entityKey = 0L;
            this.entityType = null;
            return this;
        }

        public ImmutableRoleRecordValue build() {
            return new ImmutableRoleRecordValue(this.roleKey, this.name, this.entityKey, this.entityType);
        }
    }
}

