/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.v870.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.v870.record.ImmutableProtocol;
import io.camunda.zeebe.protocol.v870.record.value.BatchOperationChunkRecordValue;
import io.camunda.zeebe.protocol.v870.record.value.BatchOperationRelated;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

@ImmutableProtocol.Type(builder=Builder.class)
@Generated(from="BatchOperationChunkRecordValue", generator="Immutables")
@SuppressFBWarnings
public final class ImmutableBatchOperationChunkRecordValue
implements BatchOperationChunkRecordValue {
    private final Long batchOperationKey;
    private final List<Long> entityKeys;
    private final Long chunkKey;
    private transient int hashCode;

    private ImmutableBatchOperationChunkRecordValue(Long batchOperationKey, List<Long> entityKeys, Long chunkKey) {
        this.batchOperationKey = batchOperationKey;
        this.entityKeys = entityKeys;
        this.chunkKey = chunkKey;
    }

    @Override
    public Long getBatchOperationKey() {
        return this.batchOperationKey;
    }

    @Override
    public List<Long> getEntityKeys() {
        return this.entityKeys;
    }

    @Override
    public Long getChunkKey() {
        return this.chunkKey;
    }

    public final ImmutableBatchOperationChunkRecordValue withBatchOperationKey(Long value) {
        if (Objects.equals(this.batchOperationKey, value)) {
            return this;
        }
        return new ImmutableBatchOperationChunkRecordValue(value, this.entityKeys, this.chunkKey);
    }

    public final ImmutableBatchOperationChunkRecordValue withEntityKeys(Long ... elements) {
        List<Long> newValue = ImmutableBatchOperationChunkRecordValue.createUnmodifiableList(false, ImmutableBatchOperationChunkRecordValue.createSafeList(Arrays.asList(elements), false, false));
        return new ImmutableBatchOperationChunkRecordValue(this.batchOperationKey, newValue, this.chunkKey);
    }

    public final ImmutableBatchOperationChunkRecordValue withEntityKeys(Iterable<? extends Long> elements) {
        if (this.entityKeys == elements) {
            return this;
        }
        List<Long> newValue = ImmutableBatchOperationChunkRecordValue.createUnmodifiableList(false, ImmutableBatchOperationChunkRecordValue.createSafeList(elements, false, false));
        return new ImmutableBatchOperationChunkRecordValue(this.batchOperationKey, newValue, this.chunkKey);
    }

    public final ImmutableBatchOperationChunkRecordValue withChunkKey(Long value) {
        if (Objects.equals(this.chunkKey, value)) {
            return this;
        }
        return new ImmutableBatchOperationChunkRecordValue(this.batchOperationKey, this.entityKeys, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBatchOperationChunkRecordValue && this.equalTo(0, (ImmutableBatchOperationChunkRecordValue)another);
    }

    private boolean equalTo(int synthetic, ImmutableBatchOperationChunkRecordValue another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return Objects.equals(this.batchOperationKey, another.batchOperationKey) && this.entityKeys.equals(another.entityKeys) && Objects.equals(this.chunkKey, another.chunkKey);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.batchOperationKey);
        h += (h << 5) + this.entityKeys.hashCode();
        h += (h << 5) + Objects.hashCode(this.chunkKey);
        return h;
    }

    public String toString() {
        return "BatchOperationChunkRecordValue{batchOperationKey=" + this.batchOperationKey + ", entityKeys=" + this.entityKeys + ", chunkKey=" + this.chunkKey + "}";
    }

    public static ImmutableBatchOperationChunkRecordValue copyOf(BatchOperationChunkRecordValue instance) {
        if (instance instanceof ImmutableBatchOperationChunkRecordValue) {
            return (ImmutableBatchOperationChunkRecordValue)instance;
        }
        return ImmutableBatchOperationChunkRecordValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @ImmutableProtocol.Builder
    @Generated(from="BatchOperationChunkRecordValue", generator="Immutables")
    public static final class Builder {
        private Long batchOperationKey;
        private List<Long> entityKeys = new ArrayList<Long>();
        private Long chunkKey;

        private Builder() {
        }

        public final Builder from(BatchOperationChunkRecordValue instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(BatchOperationRelated instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            BatchOperationRelated instance;
            long bits = 0L;
            if (object instanceof BatchOperationChunkRecordValue) {
                instance = (BatchOperationChunkRecordValue)object;
                this.addAllEntityKeys(instance.getEntityKeys());
                Long chunkKeyValue = instance.getChunkKey();
                if (chunkKeyValue != null) {
                    this.withChunkKey(chunkKeyValue);
                }
                if ((bits & 1L) == 0L) {
                    Long batchOperationKeyValue = instance.getBatchOperationKey();
                    if (batchOperationKeyValue != null) {
                        this.withBatchOperationKey(batchOperationKeyValue);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof BatchOperationRelated) {
                instance = (BatchOperationRelated)object;
                if ((bits & 1L) == 0L) {
                    Long batchOperationKeyValue = instance.getBatchOperationKey();
                    if (batchOperationKeyValue != null) {
                        this.withBatchOperationKey(batchOperationKeyValue);
                    }
                    bits |= 1L;
                }
            }
        }

        public final Builder withBatchOperationKey(Long batchOperationKey) {
            this.batchOperationKey = batchOperationKey;
            return this;
        }

        public final Builder addEntityKey(Long element) {
            this.entityKeys.add(element);
            return this;
        }

        public final Builder addEntityKeys(Long ... elements) {
            for (Long element : elements) {
                this.entityKeys.add(element);
            }
            return this;
        }

        public final Builder withEntityKeys(Iterable<? extends Long> elements) {
            this.entityKeys.clear();
            return this.addAllEntityKeys(elements);
        }

        public final Builder addAllEntityKeys(Iterable<? extends Long> elements) {
            for (Long l : elements) {
                this.entityKeys.add(l);
            }
            return this;
        }

        public final Builder withChunkKey(Long chunkKey) {
            this.chunkKey = chunkKey;
            return this;
        }

        public Builder clear() {
            this.batchOperationKey = null;
            this.entityKeys.clear();
            this.chunkKey = null;
            return this;
        }

        public ImmutableBatchOperationChunkRecordValue build() {
            return new ImmutableBatchOperationChunkRecordValue(this.batchOperationKey, ImmutableBatchOperationChunkRecordValue.createUnmodifiableList(true, this.entityKeys), this.chunkKey);
        }
    }
}

