/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.v870.management;

import io.camunda.zeebe.protocol.v870.management.AdminRequestDecoder;
import io.camunda.zeebe.protocol.v870.management.AdminRequestType;
import io.camunda.zeebe.protocol.v870.management.MessageHeaderEncoder;
import io.camunda.zeebe.protocol.v870.management.MetaAttribute;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.ArrayUtil;
import org.agrona.sbe.MessageEncoderFlyweight;

public final class AdminRequestEncoder
implements MessageEncoderFlyweight {
    public static final int BLOCK_LENGTH = 13;
    public static final int TEMPLATE_ID = 1;
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 0;
    public static final String SEMANTIC_VERSION = "8.8.0-alpha3";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final AdminRequestEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int offset;
    private int limit;

    public int sbeBlockLength() {
        return 13;
    }

    public int sbeTemplateId() {
        return 1;
    }

    public int sbeSchemaId() {
        return 1;
    }

    public int sbeSchemaVersion() {
        return 0;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public AdminRequestEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.limit(offset + 13);
        return this;
    }

    public AdminRequestEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(13).templateId(1).schemaId(1).version(0);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int partitionIdId() {
        return 1;
    }

    public static int partitionIdSinceVersion() {
        return 0;
    }

    public static int partitionIdEncodingOffset() {
        return 0;
    }

    public static int partitionIdEncodingLength() {
        return 2;
    }

    public static String partitionIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int partitionIdNullValue() {
        return 65535;
    }

    public static int partitionIdMinValue() {
        return 0;
    }

    public static int partitionIdMaxValue() {
        return 65534;
    }

    public AdminRequestEncoder partitionId(int value) {
        this.buffer.putShort(this.offset + 0, (short)value, BYTE_ORDER);
        return this;
    }

    public static int typeId() {
        return 2;
    }

    public static int typeSinceVersion() {
        return 0;
    }

    public static int typeEncodingOffset() {
        return 2;
    }

    public static int typeEncodingLength() {
        return 1;
    }

    public static String typeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public AdminRequestEncoder type(AdminRequestType value) {
        this.buffer.putByte(this.offset + 2, (byte)value.value());
        return this;
    }

    public static int brokerIdId() {
        return 3;
    }

    public static int brokerIdSinceVersion() {
        return 0;
    }

    public static int brokerIdEncodingOffset() {
        return 3;
    }

    public static int brokerIdEncodingLength() {
        return 2;
    }

    public static String brokerIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public static int brokerIdNullValue() {
        return 65535;
    }

    public static int brokerIdMinValue() {
        return 0;
    }

    public static int brokerIdMaxValue() {
        return 65534;
    }

    public AdminRequestEncoder brokerId(int value) {
        this.buffer.putShort(this.offset + 3, (short)value, BYTE_ORDER);
        return this;
    }

    public static int keyId() {
        return 4;
    }

    public static int keySinceVersion() {
        return 0;
    }

    public static int keyEncodingOffset() {
        return 5;
    }

    public static int keyEncodingLength() {
        return 8;
    }

    public static String keyMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public static long keyNullValue() {
        return -1L;
    }

    public static long keyMinValue() {
        return 0L;
    }

    public static long keyMaxValue() {
        return -2L;
    }

    public AdminRequestEncoder key(long value) {
        this.buffer.putLong(this.offset + 5, value, BYTE_ORDER);
        return this;
    }

    public static int payloadId() {
        return 5;
    }

    public static String payloadCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String payloadMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int payloadHeaderLength() {
        return 4;
    }

    public AdminRequestEncoder putPayload(DirectBuffer src, int srcOffset, int length) {
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, BYTE_ORDER);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public AdminRequestEncoder putPayload(byte[] src, int srcOffset, int length) {
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, BYTE_ORDER);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public AdminRequestEncoder payload(String value) {
        byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
        int length = bytes.length;
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, BYTE_ORDER);
        this.buffer.putBytes(limit + 4, bytes, 0, length);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        AdminRequestDecoder decoder = new AdminRequestDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.offset, 13, 0);
        return decoder.appendTo(builder);
    }
}

