/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.zeebeimport.v870.processors.os;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.tasklist.CommonUtils;
import io.camunda.tasklist.data.conditionals.OpenSearchCondition;
import io.camunda.tasklist.store.FormStore;
import io.camunda.tasklist.util.DateUtil;
import io.camunda.tasklist.zeebeimport.v870.record.Intent;
import io.camunda.tasklist.zeebeimport.v870.record.value.JobRecordValueImpl;
import io.camunda.webapps.schema.descriptors.tasklist.template.TaskTemplate;
import io.camunda.webapps.schema.entities.tasklist.TaskEntity;
import io.camunda.webapps.schema.entities.tasklist.TaskState;
import io.camunda.zeebe.protocol.v870.record.Record;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import org.opensearch.client.opensearch.core.bulk.BulkOperation;
import org.opensearch.client.opensearch.core.bulk.UpdateOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class JobZeebeRecordProcessorOpenSearch {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobZeebeRecordProcessorOpenSearch.class);
    private static final Pattern EMBEDDED_FORMS_PATTERN = Pattern.compile("^camunda-forms:bpmn:.*");
    @Autowired
    @Qualifier(value="tasklistObjectMapper")
    private ObjectMapper objectMapper;
    @Autowired
    private TaskTemplate taskTemplate;
    @Autowired
    private FormStore formStore;

    public void processJobRecord(Record record, List<BulkOperation> operations) {
        JobRecordValueImpl recordValue = (JobRecordValueImpl)record.getValue();
        if (recordValue.getType().equals("io.camunda.zeebe:userTask") && record.getIntent() != null && !record.getIntent().name().equals(Intent.TIMED_OUT.name())) {
            operations.add(this.persistTask(record, recordValue));
        }
    }

    private BulkOperation persistTask(Record record, JobRecordValueImpl recordValue) {
        String candidateUsers;
        String candidateGroups;
        OffsetDateTime offSetFollowUpDate;
        String followUpDate;
        OffsetDateTime offSetDueDate;
        String processDefinitionId = String.valueOf(recordValue.getProcessDefinitionKey());
        TaskEntity entity = (TaskEntity)((TaskEntity)((TaskEntity)((TaskEntity)new TaskEntity().setImplementation(TaskEntity.TaskImplementation.JOB_WORKER).setId(String.valueOf(record.getKey()))).setKey(Long.valueOf(record.getKey()))).setPartitionId(record.getPartitionId())).setFlowNodeBpmnId(recordValue.getElementId()).setFlowNodeInstanceId(String.valueOf(recordValue.getElementInstanceKey())).setProcessInstanceId(String.valueOf(recordValue.getProcessInstanceKey())).setBpmnProcessId(recordValue.getBpmnProcessId()).setProcessDefinitionId(processDefinitionId).setTenantId(recordValue.getTenantId());
        String dueDate = recordValue.getCustomHeaders().get("io.camunda.zeebe:dueDate");
        if (dueDate != null && (offSetDueDate = DateUtil.toOffsetDateTime((String)dueDate)) != null) {
            entity.setDueDate(offSetDueDate);
        }
        if ((followUpDate = recordValue.getCustomHeaders().get("io.camunda.zeebe:followUpDate")) != null && (offSetFollowUpDate = DateUtil.toOffsetDateTime((String)followUpDate)) != null) {
            entity.setFollowUpDate(offSetFollowUpDate);
        }
        String formKey = recordValue.getCustomHeaders().get("io.camunda.zeebe:formKey");
        entity.setFormKey(formKey);
        Optional.ofNullable(formKey).flatMap(arg_0 -> ((FormStore)this.formStore).getFormByKey(arg_0)).ifPresentOrElse(linkedForm -> {
            entity.setFormVersion(linkedForm.version());
            entity.setFormId(linkedForm.bpmnId());
            entity.setIsFormEmbedded(Boolean.valueOf(false));
        }, () -> {
            entity.setIsFormEmbedded(Boolean.valueOf(formKey != null && EMBEDDED_FORMS_PATTERN.matcher(formKey).matches()));
            entity.setFormVersion(null);
            entity.setFormId(null);
        });
        String assignee = recordValue.getCustomHeaders().get("io.camunda.zeebe:assignee");
        if (assignee != null) {
            entity.setAssignee(assignee);
        }
        if ((candidateGroups = recordValue.getCustomHeaders().get("io.camunda.zeebe:candidateGroups")) != null) {
            try {
                entity.setCandidateGroups((String[])this.objectMapper.readValue(candidateGroups, String[].class));
            }
            catch (JsonProcessingException e) {
                LOGGER.warn(String.format("Candidate groups can't be parsed from %s: %s", candidateGroups, e.getMessage()), (Throwable)e);
            }
        }
        if ((candidateUsers = recordValue.getCustomHeaders().get("io.camunda.zeebe:candidateUsers")) != null) {
            try {
                entity.setCandidateUsers((String[])this.objectMapper.readValue(candidateUsers, String[].class));
            }
            catch (JsonProcessingException e) {
                LOGGER.warn(String.format("Candidate users can't be parsed from %s: %s", candidateUsers, e.getMessage()), (Throwable)e);
            }
        }
        Intent intent = (Intent)record.getIntent();
        switch (intent) {
            case CANCELED: {
                entity.setState(TaskState.CANCELED).setCompletionTime(DateUtil.toOffsetDateTime((Instant)Instant.ofEpochMilli(record.getTimestamp())));
                break;
            }
            case COMPLETED: {
                entity.setState(TaskState.COMPLETED).setCompletionTime(DateUtil.toOffsetDateTime((Instant)Instant.ofEpochMilli(record.getTimestamp())));
                break;
            }
            case CREATED: {
                entity.setState(TaskState.CREATED).setCreationTime(DateUtil.toOffsetDateTime((Instant)Instant.ofEpochMilli(record.getTimestamp())));
                break;
            }
            case MIGRATED: 
            case RECURRED_AFTER_BACKOFF: {
                entity.setState(TaskState.CREATED);
                break;
            }
            case FAILED: {
                if (recordValue.getRetries() > 0) {
                    if (recordValue.getRetryBackoff() > 0L) {
                        entity.setState(TaskState.FAILED);
                        break;
                    }
                    entity.setState(TaskState.CREATED);
                    break;
                }
                entity.setState(TaskState.FAILED);
                break;
            }
            default: {
                LOGGER.warn(String.format("Intent %s not supported", intent));
            }
        }
        return this.getTaskQuery(entity, intent);
    }

    private BulkOperation getTaskQuery(TaskEntity entity, Intent intent) {
        LOGGER.debug("Task instance: id {}", (Object)entity.getId());
        HashMap<String, Object> updateFields = new HashMap<String, Object>();
        if (intent == Intent.MIGRATED) {
            updateFields.put("flowNodeBpmnId", entity.getFlowNodeBpmnId());
            updateFields.put("bpmnProcessId", entity.getBpmnProcessId());
            updateFields.put("processDefinitionId", entity.getProcessDefinitionId());
        } else {
            updateFields.put("state", entity.getState());
            updateFields.put("completionTime", entity.getCompletionTime());
        }
        return (BulkOperation)new BulkOperation.Builder().update(UpdateOperation.of(u -> ((UpdateOperation.Builder)((UpdateOperation.Builder)u.index(this.taskTemplate.getFullQualifiedName())).id(entity.getId())).document((Object)CommonUtils.getJsonObjectFromEntity((Object)updateFields)).upsert((Object)CommonUtils.getJsonObjectFromEntity((Object)entity)).retryOnConflict(Integer.valueOf(3)))).build();
    }
}

