/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.zeebeimport.v870.processors.es;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.tasklist.data.conditionals.ElasticSearchCondition;
import io.camunda.tasklist.exceptions.PersistenceException;
import io.camunda.tasklist.zeebeimport.v870.processors.common.UserTaskRecordToTaskEntityMapper;
import io.camunda.tasklist.zeebeimport.v870.processors.common.UserTaskRecordToVariableEntityMapper;
import io.camunda.webapps.schema.descriptors.tasklist.template.SnapshotTaskVariableTemplate;
import io.camunda.webapps.schema.descriptors.tasklist.template.TaskTemplate;
import io.camunda.webapps.schema.entities.tasklist.SnapshotTaskVariableEntity;
import io.camunda.webapps.schema.entities.tasklist.TaskEntity;
import io.camunda.zeebe.protocol.v870.record.Record;
import io.camunda.zeebe.protocol.v870.record.value.UserTaskRecordValue;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class UserTaskZeebeRecordProcessorElasticSearch {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserTaskZeebeRecordProcessorElasticSearch.class);
    @Autowired
    @Qualifier(value="tasklistObjectMapper")
    private ObjectMapper objectMapper;
    @Autowired
    private TaskTemplate taskTemplate;
    @Autowired
    private UserTaskRecordToVariableEntityMapper userTaskRecordToVariableEntityMapper;
    @Autowired
    @Qualifier(value="tasklistSnapshotTaskVariableTemplate")
    private SnapshotTaskVariableTemplate variableIndex;
    @Autowired
    private UserTaskRecordToTaskEntityMapper userTaskRecordToTaskEntityMapper;

    public void processUserTaskRecord(Record<UserTaskRecordValue> record, BulkRequest bulkRequest) throws PersistenceException {
        Optional<TaskEntity> taskEntity = this.userTaskRecordToTaskEntityMapper.map(record);
        if (taskEntity.isPresent()) {
            bulkRequest.add(this.getTaskQuery(taskEntity.get(), record));
            if (!record.getValue().getVariables().isEmpty()) {
                List<SnapshotTaskVariableEntity> variables = this.userTaskRecordToVariableEntityMapper.mapVariables(record);
                for (SnapshotTaskVariableEntity variable : variables) {
                    bulkRequest.add(this.getVariableQuery(variable));
                }
            }
        }
    }

    private UpdateRequest getTaskQuery(TaskEntity entity, Record record) throws PersistenceException {
        try {
            Map<String, Object> updateFields = this.userTaskRecordToTaskEntityMapper.getUpdateFieldsMap(entity, record);
            Map jsonMap = (Map)this.objectMapper.readValue(this.objectMapper.writeValueAsString(updateFields), HashMap.class);
            return ((UpdateRequest)new UpdateRequest().index(this.taskTemplate.getFullQualifiedName())).id(entity.getId()).upsert(this.objectMapper.writeValueAsString((Object)entity), XContentType.JSON).doc(jsonMap).retryOnConflict(3);
        }
        catch (IOException e) {
            throw new PersistenceException(String.format("Error preparing the query to upsert task instance [%s]", entity.getId()), (Throwable)e);
        }
    }

    private UpdateRequest getVariableQuery(SnapshotTaskVariableEntity variable) throws PersistenceException {
        try {
            LOGGER.debug("Variable instance for list view: id {}", (Object)variable.getId());
            HashMap<String, Object> updateFields = new HashMap<String, Object>();
            updateFields.put("value", variable.getValue());
            updateFields.put("fullValue", variable.getFullValue());
            updateFields.put("isPreview", variable.getIsPreview());
            return ((UpdateRequest)new UpdateRequest().index(this.variableIndex.getFullQualifiedName())).id(variable.getId()).upsert(this.objectMapper.writeValueAsString((Object)variable), XContentType.JSON).doc(updateFields).retryOnConflict(3);
        }
        catch (IOException e) {
            throw new PersistenceException(String.format("Error preparing the query to upsert variable instance [%s]  for list view", variable.getId()), (Throwable)e);
        }
    }
}

