/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.zeebeimport.v870.processors.es;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.tasklist.Metrics;
import io.camunda.tasklist.data.conditionals.ElasticSearchCondition;
import io.camunda.tasklist.exceptions.PersistenceException;
import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import io.camunda.tasklist.util.ElasticsearchUtil;
import io.camunda.tasklist.zeebe.ImportValueType;
import io.camunda.tasklist.zeebeimport.ImportBatch;
import io.camunda.tasklist.zeebeimport.es.AbstractImportBatchProcessorElasticSearch;
import io.camunda.tasklist.zeebeimport.v870.processors.es.FormZeebeRecordProcessorElasticSearch;
import io.camunda.tasklist.zeebeimport.v870.processors.es.JobZeebeRecordProcessorElasticSearch;
import io.camunda.tasklist.zeebeimport.v870.processors.es.ProcessInstanceZeebeRecordProcessorElasticSearch;
import io.camunda.tasklist.zeebeimport.v870.processors.es.ProcessZeebeRecordProcessorElasticSearch;
import io.camunda.tasklist.zeebeimport.v870.processors.es.UserTaskZeebeRecordProcessorElasticSearch;
import io.camunda.tasklist.zeebeimport.v870.processors.es.VariableZeebeRecordProcessorElasticSearch;
import io.camunda.tasklist.zeebeimport.v870.record.RecordImpl;
import io.camunda.tasklist.zeebeimport.v870.record.value.JobRecordValueImpl;
import io.camunda.tasklist.zeebeimport.v870.record.value.ProcessInstanceRecordValueImpl;
import io.camunda.tasklist.zeebeimport.v870.record.value.UserTaskRecordValueImpl;
import io.camunda.tasklist.zeebeimport.v870.record.value.VariableRecordValueImpl;
import io.camunda.tasklist.zeebeimport.v870.record.value.deployment.DeployedProcessImpl;
import io.camunda.tasklist.zeebeimport.v870.record.value.deployment.FormRecordImpl;
import io.camunda.zeebe.protocol.v870.record.Record;
import io.camunda.zeebe.protocol.v870.record.RecordValue;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.action.bulk.BulkRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class BulkProcessorElasticSearch
extends AbstractImportBatchProcessorElasticSearch {
    private static final Logger LOGGER = LoggerFactory.getLogger(BulkProcessorElasticSearch.class);
    @Autowired
    private ProcessInstanceZeebeRecordProcessorElasticSearch processInstanceZeebeRecordProcessor;
    @Autowired
    private VariableZeebeRecordProcessorElasticSearch variableZeebeRecordProcessor;
    @Autowired
    private JobZeebeRecordProcessorElasticSearch jobZeebeRecordProcessor;
    @Autowired
    private ProcessZeebeRecordProcessorElasticSearch processZeebeRecordProcessor;
    @Autowired
    private FormZeebeRecordProcessorElasticSearch formZeebeRecordProcessor;
    @Autowired
    private UserTaskZeebeRecordProcessorElasticSearch userTaskZeebeRecordProcessor;
    @Autowired
    @Qualifier(value="tasklistObjectMapper")
    private ObjectMapper objectMapper;
    @Autowired
    private Metrics metrics;

    protected void processZeebeRecords(ImportBatch importBatchElasticSearch, BulkRequest bulkRequest) throws PersistenceException {
        JavaType valueType = this.objectMapper.getTypeFactory().constructParametricType(RecordImpl.class, new Class[]{this.getRecordValueClass(importBatchElasticSearch.getImportValueType())});
        List zeebeRecords = ElasticsearchUtil.mapSearchHits((List)importBatchElasticSearch.getHits(), (ObjectMapper)this.objectMapper, (JavaType)valueType);
        ImportValueType importValueType = importBatchElasticSearch.getImportValueType();
        LOGGER.debug("Writing [{}] Zeebe records to Elasticsearch", (Object)zeebeRecords.size());
        block8: for (Record record : zeebeRecords) {
            switch (importValueType) {
                case PROCESS_INSTANCE: {
                    this.processInstanceZeebeRecordProcessor.processProcessInstanceRecord(record, bulkRequest);
                    continue block8;
                }
                case VARIABLE: {
                    this.variableZeebeRecordProcessor.processVariableRecord(record, bulkRequest);
                    continue block8;
                }
                case JOB: {
                    this.jobZeebeRecordProcessor.processJobRecord(record, bulkRequest);
                    continue block8;
                }
                case PROCESS: {
                    this.processZeebeRecordProcessor.processDeploymentRecord(record, bulkRequest);
                    continue block8;
                }
                case FORM: {
                    this.formZeebeRecordProcessor.processFormRecord(record, bulkRequest);
                    continue block8;
                }
                case USER_TASK: {
                    this.userTaskZeebeRecordProcessor.processUserTaskRecord(record, bulkRequest);
                    continue block8;
                }
            }
            LOGGER.debug("Default case triggered for type {}", (Object)importValueType);
        }
        this.recordRecordImportTime(zeebeRecords);
    }

    private void recordRecordImportTime(List<Record> zeebeRecords) {
        long currentTime = OffsetDateTime.now().toInstant().toEpochMilli();
        zeebeRecords.forEach(record -> this.metrics.getTimer("tasklist.import.time", new String[]{"type", record.getValueType().toString(), "partition", String.valueOf(record.getPartitionId())}).record(currentTime - record.getTimestamp(), TimeUnit.MILLISECONDS));
    }

    protected Class<? extends RecordValue> getRecordValueClass(ImportValueType importValueType) {
        switch (importValueType) {
            case PROCESS_INSTANCE: {
                return ProcessInstanceRecordValueImpl.class;
            }
            case JOB: {
                return JobRecordValueImpl.class;
            }
            case VARIABLE: {
                return VariableRecordValueImpl.class;
            }
            case PROCESS: {
                return DeployedProcessImpl.class;
            }
            case FORM: {
                return FormRecordImpl.class;
            }
            case USER_TASK: {
                return UserTaskRecordValueImpl.class;
            }
        }
        throw new TasklistRuntimeException(String.format("No value type class found for: %s", importValueType));
    }

    public String getZeebeVersion() {
        return "8.7";
    }
}

