/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.zeebeimport.v870.processors.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.tasklist.store.FormStore;
import io.camunda.tasklist.util.DateUtil;
import io.camunda.tasklist.zeebeimport.v870.record.Intent;
import io.camunda.webapps.schema.entities.tasklist.TaskEntity;
import io.camunda.webapps.schema.entities.tasklist.TaskState;
import io.camunda.zeebe.protocol.v870.record.Record;
import io.camunda.zeebe.protocol.v870.record.value.UserTaskRecordValue;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class UserTaskRecordToTaskEntityMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserTaskRecordToTaskEntityMapper.class);
    private static final Set<Intent> SUPPORTED_INTENTS = EnumSet.of(Intent.CREATED, new Intent[]{Intent.COMPLETED, Intent.CANCELED, Intent.MIGRATED, Intent.ASSIGNED, Intent.UPDATED});
    private final FormStore formStore;
    private final ObjectMapper objectMapper;

    public UserTaskRecordToTaskEntityMapper(@Qualifier(value="tasklistObjectMapper") ObjectMapper objectMapper, FormStore formStore) {
        this.objectMapper = objectMapper;
        this.formStore = formStore;
    }

    public Optional<TaskEntity> map(Record<UserTaskRecordValue> record) {
        List<String> candidateUsers;
        List<String> candidateGroups;
        String assignee;
        long formKey;
        OffsetDateTime offSetFollowUpDate;
        String followUpDate;
        OffsetDateTime offSetDueDate;
        Intent intent = (Intent)record.getIntent();
        LOGGER.debug("Intent {}", (Object)intent);
        if (intent == null || !SUPPORTED_INTENTS.contains(intent)) {
            LOGGER.debug("Unsupported intent={}. Skipping it", (Object)intent);
            return Optional.empty();
        }
        UserTaskRecordValue recordValue = record.getValue();
        String processDefinitionId = String.valueOf(recordValue.getProcessDefinitionKey());
        TaskEntity entity = ((TaskEntity)((TaskEntity)((TaskEntity)((TaskEntity)new TaskEntity().setImplementation(TaskEntity.TaskImplementation.ZEEBE_USER_TASK).setId(String.valueOf(record.getKey()))).setKey(Long.valueOf(record.getKey()))).setPartitionId(record.getPartitionId())).setFlowNodeBpmnId(recordValue.getElementId()).setFlowNodeInstanceId(String.valueOf(recordValue.getElementInstanceKey())).setProcessInstanceId(String.valueOf(recordValue.getProcessInstanceKey())).setBpmnProcessId(recordValue.getBpmnProcessId()).setProcessDefinitionId(processDefinitionId).setTenantId(recordValue.getTenantId())).setExternalFormReference(recordValue.getExternalFormReference() == null || recordValue.getExternalFormReference().isBlank() ? null : recordValue.getExternalFormReference()).setCustomHeaders(recordValue.getCustomHeaders()).setProcessDefinitionVersion(Integer.valueOf(recordValue.getProcessDefinitionVersion())).setPriority(Integer.valueOf(recordValue.getPriority()));
        switch (intent) {
            case CANCELED: {
                entity.setState(TaskState.CANCELED).setCompletionTime(DateUtil.toOffsetDateTime((Instant)Instant.ofEpochMilli(record.getTimestamp())));
                break;
            }
            case COMPLETED: {
                entity.setState(TaskState.COMPLETED).setCompletionTime(DateUtil.toOffsetDateTime((Instant)Instant.ofEpochMilli(record.getTimestamp())));
                break;
            }
            case CREATED: {
                entity.setState(TaskState.CREATED).setCreationTime(DateUtil.toOffsetDateTime((Instant)Instant.ofEpochMilli(record.getTimestamp())));
                break;
            }
            case MIGRATED: {
                entity.setState(TaskState.CREATED);
                break;
            }
        }
        String dueDate = recordValue.getDueDate();
        if (StringUtils.isNotEmpty((CharSequence)dueDate) && (offSetDueDate = DateUtil.toOffsetDateTime((String)dueDate)) != null) {
            entity.setDueDate(offSetDueDate);
        }
        if (StringUtils.isNotEmpty((CharSequence)(followUpDate = recordValue.getFollowUpDate())) && (offSetFollowUpDate = DateUtil.toOffsetDateTime((String)followUpDate)) != null) {
            entity.setFollowUpDate(offSetFollowUpDate);
        }
        if ((formKey = recordValue.getFormKey()) != -1L) {
            String strFromKey = String.valueOf(formKey);
            entity.setFormKey(strFromKey).setIsFormEmbedded(Boolean.valueOf(false));
            this.formStore.getFormByKey(strFromKey).ifPresentOrElse(linkedForm -> {
                entity.setFormVersion(linkedForm.version());
                entity.setFormId(linkedForm.bpmnId());
            }, () -> LOGGER.warn("Form with key={} cannot be found", (Object)strFromKey));
        }
        if (StringUtils.isNotEmpty((CharSequence)(assignee = recordValue.getAssignee()))) {
            entity.setAssignee(assignee);
        }
        if (!(candidateGroups = recordValue.getCandidateGroupsList()).isEmpty()) {
            entity.setCandidateGroups(candidateGroups.toArray(new String[candidateGroups.size()]));
        }
        if (!(candidateUsers = recordValue.getCandidateUsersList()).isEmpty()) {
            entity.setCandidateUsers(candidateUsers.toArray(new String[candidateUsers.size()]));
        }
        return Optional.of(entity);
    }

    public Map<String, Object> getUpdateFieldsMap(TaskEntity entity, Record<UserTaskRecordValue> record) {
        HashMap<String, Object> updateFields = new HashMap<String, Object>();
        Intent intent = (Intent)record.getIntent();
        if (entity.getState() != null) {
            updateFields.put("state", entity.getState());
        }
        switch (intent) {
            case MIGRATED: {
                updateFields.put("flowNodeBpmnId", entity.getFlowNodeBpmnId());
                updateFields.put("bpmnProcessId", entity.getBpmnProcessId());
                updateFields.put("processDefinitionId", entity.getProcessDefinitionId());
                break;
            }
            case CANCELED: 
            case COMPLETED: {
                updateFields.put("state", entity.getState());
                updateFields.put("completionTime", entity.getCompletionTime());
                break;
            }
            case ASSIGNED: {
                updateFields.put("assignee", entity.getAssignee());
                break;
            }
            case UPDATED: {
                UserTaskRecordValue recordValue = record.getValue();
                List<String> changedAttributes = recordValue.getChangedAttributes();
                Iterator<String> iterator = changedAttributes.iterator();
                block20: while (iterator.hasNext()) {
                    String attribute;
                    switch (attribute = iterator.next()) {
                        case "candidateGroupsList": {
                            updateFields.put("candidateGroups", entity.getCandidateGroups());
                            continue block20;
                        }
                        case "candidateUsersList": {
                            updateFields.put("candidateUsers", entity.getCandidateUsers());
                            continue block20;
                        }
                        case "dueDate": {
                            updateFields.put("dueDate", entity.getDueDate());
                            continue block20;
                        }
                        case "followUpDate": {
                            updateFields.put("followUpDate", entity.getFollowUpDate());
                            continue block20;
                        }
                        case "priority": {
                            updateFields.put("priority", entity.getPriority());
                            continue block20;
                        }
                    }
                    LOGGER.warn("Attribute update not mapped while importing ZEEBE_USER_TASKS: {}", (Object)attribute);
                }
                break;
            }
        }
        return updateFields;
    }
}

