/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.v870.record.value;

import java.util.Arrays;
import java.util.Optional;

public enum BpmnEventType {
    UNSPECIFIED(null),
    CONDITIONAL("conditional"),
    ERROR("error"),
    ESCALATION("escalation"),
    LINK("link"),
    MESSAGE("message"),
    NONE("none"),
    SIGNAL("signal"),
    TERMINATE("terminate"),
    TIMER("timer"),
    COMPENSATION("compensation");

    private final String eventTypeName;

    private BpmnEventType(String eventTypeName) {
        this.eventTypeName = eventTypeName;
    }

    public Optional<String> getEventTypeName() {
        return Optional.ofNullable(this.eventTypeName);
    }

    public static BpmnEventType bpmnEventTypeFor(String eventTypeName) {
        return Arrays.stream(BpmnEventType.values()).filter(bpmnEventType -> bpmnEventType.eventTypeName != null && bpmnEventType.eventTypeName.equals(eventTypeName)).findFirst().orElseThrow(() -> new RuntimeException("Unsupported BPMN event of type " + eventTypeName));
    }
}

