/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.zeebeimport.v870.processors.os;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.tasklist.CommonUtils;
import io.camunda.tasklist.data.conditionals.OpenSearchCondition;
import io.camunda.tasklist.entities.TaskEntity;
import io.camunda.tasklist.entities.TaskVariableEntity;
import io.camunda.tasklist.exceptions.PersistenceException;
import io.camunda.tasklist.schema.templates.TaskTemplate;
import io.camunda.tasklist.schema.templates.TaskVariableTemplate;
import io.camunda.tasklist.zeebeimport.v870.processors.common.UserTaskRecordToTaskEntityMapper;
import io.camunda.tasklist.zeebeimport.v870.processors.common.UserTaskRecordToVariableEntityMapper;
import io.camunda.zeebe.protocol.v870.record.Record;
import io.camunda.zeebe.protocol.v870.record.value.UserTaskRecordValue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.opensearch.client.opensearch.core.bulk.BulkOperation;
import org.opensearch.client.opensearch.core.bulk.UpdateOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class UserTaskZeebeRecordProcessorOpenSearch {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserTaskZeebeRecordProcessorOpenSearch.class);
    @Autowired
    @Qualifier(value="tasklistObjectMapper")
    private ObjectMapper objectMapper;
    @Autowired
    private TaskTemplate taskTemplate;
    @Autowired
    private TaskVariableTemplate variableIndex;
    @Autowired
    private UserTaskRecordToTaskEntityMapper userTaskRecordToTaskEntityMapper;
    @Autowired
    private UserTaskRecordToVariableEntityMapper userTaskRecordToVariableEntityMapper;

    public void processUserTaskRecord(Record<UserTaskRecordValue> record, List<BulkOperation> operations) throws PersistenceException {
        Optional<TaskEntity> taskEntity = this.userTaskRecordToTaskEntityMapper.map(record);
        if (taskEntity.isPresent()) {
            operations.add(this.getTaskQuery(taskEntity.get(), record));
        }
        if (!record.getValue().getVariables().isEmpty()) {
            List<TaskVariableEntity> variables = this.userTaskRecordToVariableEntityMapper.mapVariables(record);
            for (TaskVariableEntity variable : variables) {
                operations.add(this.getVariableQuery(variable, record.getValue().getProcessInstanceKey()));
            }
        }
    }

    private BulkOperation getTaskQuery(TaskEntity entity, Record record) {
        Map<String, Object> updateFields = this.userTaskRecordToTaskEntityMapper.getUpdateFieldsMap(entity, record);
        return (BulkOperation)new BulkOperation.Builder().update(UpdateOperation.of(u -> ((UpdateOperation.Builder)((UpdateOperation.Builder)u.index(this.taskTemplate.getFullQualifiedName())).id(entity.getId())).document((Object)CommonUtils.getJsonObjectFromEntity((Object)updateFields)).upsert((Object)CommonUtils.getJsonObjectFromEntity((Object)entity)).retryOnConflict(Integer.valueOf(3)))).build();
    }

    private BulkOperation getVariableQuery(TaskVariableEntity variable, Long processInstanceKey) {
        LOGGER.debug("Variable instance for list view: id {}", (Object)variable.getId());
        HashMap<String, Object> updateFields = new HashMap<String, Object>();
        updateFields.put("value", variable.getValue());
        updateFields.put("fullValue", variable.getFullValue());
        updateFields.put("isPreview", variable.getIsPreview());
        updateFields.put("processInstanceKey", processInstanceKey);
        return (BulkOperation)new BulkOperation.Builder().update(UpdateOperation.of(u -> ((UpdateOperation.Builder)((UpdateOperation.Builder)u.index(this.variableIndex.getFullQualifiedName())).id(variable.getId())).document((Object)CommonUtils.getJsonObjectFromEntity((Object)updateFields)).upsert((Object)CommonUtils.getJsonObjectFromEntity((Object)variable)).retryOnConflict(Integer.valueOf(3)))).build();
    }
}

