/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.v870.record.value.deployment;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.v870.record.ImmutableProtocol;
import io.camunda.zeebe.protocol.v870.record.value.TenantOwned;
import io.camunda.zeebe.protocol.v870.record.value.deployment.FormMetadataValue;
import java.util.Arrays;
import java.util.Objects;
import org.immutables.value.Generated;

@ImmutableProtocol.Type(builder=Builder.class)
@Generated(from="FormMetadataValue", generator="Immutables")
@SuppressFBWarnings
public final class ImmutableFormMetadataValue
implements FormMetadataValue {
    private final String tenantId;
    private final String formId;
    private final int version;
    private final String versionTag;
    private final long formKey;
    private final String resourceName;
    private final byte[] checksum;
    private final boolean duplicate;
    private final long deploymentKey;
    private transient int hashCode;

    private ImmutableFormMetadataValue(String tenantId, String formId, int version, String versionTag, long formKey, String resourceName, byte[] checksum, boolean duplicate, long deploymentKey) {
        this.tenantId = tenantId;
        this.formId = formId;
        this.version = version;
        this.versionTag = versionTag;
        this.formKey = formKey;
        this.resourceName = resourceName;
        this.checksum = checksum;
        this.duplicate = duplicate;
        this.deploymentKey = deploymentKey;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public String getFormId() {
        return this.formId;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public String getVersionTag() {
        return this.versionTag;
    }

    @Override
    public long getFormKey() {
        return this.formKey;
    }

    @Override
    public String getResourceName() {
        return this.resourceName;
    }

    @Override
    public byte[] getChecksum() {
        return this.checksum;
    }

    @Override
    public boolean isDuplicate() {
        return this.duplicate;
    }

    @Override
    public long getDeploymentKey() {
        return this.deploymentKey;
    }

    public final ImmutableFormMetadataValue withTenantId(String value) {
        if (Objects.equals(this.tenantId, value)) {
            return this;
        }
        return new ImmutableFormMetadataValue(value, this.formId, this.version, this.versionTag, this.formKey, this.resourceName, this.checksum, this.duplicate, this.deploymentKey);
    }

    public final ImmutableFormMetadataValue withFormId(String value) {
        if (Objects.equals(this.formId, value)) {
            return this;
        }
        return new ImmutableFormMetadataValue(this.tenantId, value, this.version, this.versionTag, this.formKey, this.resourceName, this.checksum, this.duplicate, this.deploymentKey);
    }

    public final ImmutableFormMetadataValue withVersion(int value) {
        if (this.version == value) {
            return this;
        }
        return new ImmutableFormMetadataValue(this.tenantId, this.formId, value, this.versionTag, this.formKey, this.resourceName, this.checksum, this.duplicate, this.deploymentKey);
    }

    public final ImmutableFormMetadataValue withVersionTag(String value) {
        if (Objects.equals(this.versionTag, value)) {
            return this;
        }
        return new ImmutableFormMetadataValue(this.tenantId, this.formId, this.version, value, this.formKey, this.resourceName, this.checksum, this.duplicate, this.deploymentKey);
    }

    public final ImmutableFormMetadataValue withFormKey(long value) {
        if (this.formKey == value) {
            return this;
        }
        return new ImmutableFormMetadataValue(this.tenantId, this.formId, this.version, this.versionTag, value, this.resourceName, this.checksum, this.duplicate, this.deploymentKey);
    }

    public final ImmutableFormMetadataValue withResourceName(String value) {
        if (Objects.equals(this.resourceName, value)) {
            return this;
        }
        return new ImmutableFormMetadataValue(this.tenantId, this.formId, this.version, this.versionTag, this.formKey, value, this.checksum, this.duplicate, this.deploymentKey);
    }

    public final ImmutableFormMetadataValue withChecksum(byte ... elements) {
        byte[] newValue = elements == null ? null : (byte[])elements.clone();
        return new ImmutableFormMetadataValue(this.tenantId, this.formId, this.version, this.versionTag, this.formKey, this.resourceName, newValue, this.duplicate, this.deploymentKey);
    }

    public final ImmutableFormMetadataValue withDuplicate(boolean value) {
        if (this.duplicate == value) {
            return this;
        }
        return new ImmutableFormMetadataValue(this.tenantId, this.formId, this.version, this.versionTag, this.formKey, this.resourceName, this.checksum, value, this.deploymentKey);
    }

    public final ImmutableFormMetadataValue withDeploymentKey(long value) {
        if (this.deploymentKey == value) {
            return this;
        }
        return new ImmutableFormMetadataValue(this.tenantId, this.formId, this.version, this.versionTag, this.formKey, this.resourceName, this.checksum, this.duplicate, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFormMetadataValue && this.equalTo(0, (ImmutableFormMetadataValue)another);
    }

    private boolean equalTo(int synthetic, ImmutableFormMetadataValue another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return Objects.equals(this.tenantId, another.tenantId) && Objects.equals(this.formId, another.formId) && this.version == another.version && Objects.equals(this.versionTag, another.versionTag) && this.formKey == another.formKey && Objects.equals(this.resourceName, another.resourceName) && Arrays.equals(this.checksum, another.checksum) && this.duplicate == another.duplicate && this.deploymentKey == another.deploymentKey;
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.tenantId);
        h += (h << 5) + Objects.hashCode(this.formId);
        h += (h << 5) + this.version;
        h += (h << 5) + Objects.hashCode(this.versionTag);
        h += (h << 5) + Long.hashCode(this.formKey);
        h += (h << 5) + Objects.hashCode(this.resourceName);
        h += (h << 5) + Arrays.hashCode(this.checksum);
        h += (h << 5) + Boolean.hashCode(this.duplicate);
        h += (h << 5) + Long.hashCode(this.deploymentKey);
        return h;
    }

    public String toString() {
        return "FormMetadataValue{tenantId=" + this.tenantId + ", formId=" + this.formId + ", version=" + this.version + ", versionTag=" + this.versionTag + ", formKey=" + this.formKey + ", resourceName=" + this.resourceName + ", checksum=" + Arrays.toString(this.checksum) + ", duplicate=" + this.duplicate + ", deploymentKey=" + this.deploymentKey + "}";
    }

    public static ImmutableFormMetadataValue copyOf(FormMetadataValue instance) {
        if (instance instanceof ImmutableFormMetadataValue) {
            return (ImmutableFormMetadataValue)instance;
        }
        return ImmutableFormMetadataValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @ImmutableProtocol.Builder
    @Generated(from="FormMetadataValue", generator="Immutables")
    public static final class Builder {
        private String tenantId;
        private String formId;
        private int version;
        private String versionTag;
        private long formKey;
        private String resourceName;
        private byte[] checksum;
        private boolean duplicate;
        private long deploymentKey;

        private Builder() {
        }

        public final Builder from(FormMetadataValue instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(TenantOwned instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            TenantOwned instance;
            long bits = 0L;
            if (object instanceof FormMetadataValue) {
                String resourceNameValue;
                String versionTagValue;
                byte[] checksumValue;
                instance = (FormMetadataValue)object;
                String formIdValue = instance.getFormId();
                if (formIdValue != null) {
                    this.withFormId(formIdValue);
                }
                this.withFormKey(instance.getFormKey());
                this.withDeploymentKey(instance.getDeploymentKey());
                if ((bits & 1L) == 0L) {
                    String tenantIdValue = instance.getTenantId();
                    if (tenantIdValue != null) {
                        this.withTenantId(tenantIdValue);
                    }
                    bits |= 1L;
                }
                if ((checksumValue = instance.getChecksum()) != null) {
                    this.withChecksum(checksumValue);
                }
                if ((versionTagValue = instance.getVersionTag()) != null) {
                    this.withVersionTag(versionTagValue);
                }
                if ((resourceNameValue = instance.getResourceName()) != null) {
                    this.withResourceName(resourceNameValue);
                }
                this.withDuplicate(instance.isDuplicate());
                this.withVersion(instance.getVersion());
            }
            if (object instanceof TenantOwned) {
                instance = (TenantOwned)object;
                if ((bits & 1L) == 0L) {
                    String tenantIdValue = instance.getTenantId();
                    if (tenantIdValue != null) {
                        this.withTenantId(tenantIdValue);
                    }
                    bits |= 1L;
                }
            }
        }

        public final Builder withTenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public final Builder withFormId(String formId) {
            this.formId = formId;
            return this;
        }

        public final Builder withVersion(int version) {
            this.version = version;
            return this;
        }

        public final Builder withVersionTag(String versionTag) {
            this.versionTag = versionTag;
            return this;
        }

        public final Builder withFormKey(long formKey) {
            this.formKey = formKey;
            return this;
        }

        public final Builder withResourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final Builder withChecksum(byte ... checksum) {
            this.checksum = checksum;
            return this;
        }

        public final Builder withDuplicate(boolean duplicate) {
            this.duplicate = duplicate;
            return this;
        }

        public final Builder withDeploymentKey(long deploymentKey) {
            this.deploymentKey = deploymentKey;
            return this;
        }

        public Builder clear() {
            this.tenantId = null;
            this.formId = null;
            this.version = 0;
            this.versionTag = null;
            this.formKey = 0L;
            this.resourceName = null;
            this.checksum = null;
            this.duplicate = false;
            this.deploymentKey = 0L;
            return this;
        }

        public ImmutableFormMetadataValue build() {
            return new ImmutableFormMetadataValue(this.tenantId, this.formId, this.version, this.versionTag, this.formKey, this.resourceName, this.checksum, this.duplicate, this.deploymentKey);
        }
    }
}

