/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.zeebeimport.v870.processors.os;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.tasklist.CommonUtils;
import io.camunda.tasklist.data.conditionals.OpenSearchCondition;
import io.camunda.tasklist.entities.FlowNodeInstanceEntity;
import io.camunda.tasklist.entities.FlowNodeState;
import io.camunda.tasklist.entities.FlowNodeType;
import io.camunda.tasklist.entities.ProcessInstanceEntity;
import io.camunda.tasklist.entities.ProcessInstanceState;
import io.camunda.tasklist.exceptions.PersistenceException;
import io.camunda.tasklist.schema.indices.FlowNodeInstanceIndex;
import io.camunda.tasklist.schema.indices.ProcessInstanceIndex;
import io.camunda.tasklist.util.ConversionUtils;
import io.camunda.tasklist.util.DateUtil;
import io.camunda.tasklist.zeebeimport.v870.record.value.ProcessInstanceRecordValueImpl;
import io.camunda.zeebe.protocol.v870.record.Record;
import io.camunda.zeebe.protocol.v870.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.v870.record.value.BpmnElementType;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opensearch.client.opensearch.core.bulk.BulkOperation;
import org.opensearch.client.opensearch.core.bulk.IndexOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class ProcessInstanceZeebeRecordProcessorOpenSearch {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessInstanceZeebeRecordProcessorOpenSearch.class);
    private static final Set<String> FLOW_NODE_STATES = new HashSet<String>(){
        {
            this.add(ProcessInstanceIntent.ELEMENT_ACTIVATING.name());
            this.add(ProcessInstanceIntent.ELEMENT_COMPLETED.name());
            this.add(ProcessInstanceIntent.ELEMENT_TERMINATED.name());
        }
    };
    private static final Set<String> PROCESS_INSTANCE_STATES = new HashSet<String>(){
        {
            this.add(ProcessInstanceIntent.ELEMENT_COMPLETED.name());
            this.add(ProcessInstanceIntent.ELEMENT_TERMINATED.name());
        }
    };
    private static final List<BpmnElementType> VARIABLE_SCOPE_TYPES = Arrays.asList(BpmnElementType.PROCESS, BpmnElementType.SUB_PROCESS, BpmnElementType.EVENT_SUB_PROCESS, BpmnElementType.USER_TASK, BpmnElementType.MULTI_INSTANCE_BODY, BpmnElementType.AD_HOC_SUB_PROCESS);
    @Autowired
    @Qualifier(value="tasklistObjectMapper")
    private ObjectMapper objectMapper;
    @Autowired
    private FlowNodeInstanceIndex flowNodeInstanceIndex;
    @Autowired
    private ProcessInstanceIndex processInstanceIndex;

    public void processProcessInstanceRecord(Record record, List<BulkOperation> operations) throws PersistenceException {
        ProcessInstanceRecordValueImpl recordValue = (ProcessInstanceRecordValueImpl)record.getValue();
        if (this.isVariableScopeType(recordValue) && FLOW_NODE_STATES.contains(record.getIntent().name())) {
            FlowNodeInstanceEntity flowNodeInstance = this.createFlowNodeInstance(record);
            operations.add(this.getFlowNodeInstanceQuery(flowNodeInstance));
        }
        if (this.isProcessEvent(recordValue) && PROCESS_INSTANCE_STATES.contains(record.getIntent().name())) {
            ProcessInstanceEntity processInstanceEntity = this.createProcessInstance(record);
            operations.add(this.getProcessInstanceQuery(processInstanceEntity));
        }
    }

    private ProcessInstanceEntity createProcessInstance(Record record) {
        ProcessInstanceEntity entity = new ProcessInstanceEntity();
        entity.setId(ConversionUtils.toStringOrNull((Object)record.getKey()));
        entity.setKey(record.getKey());
        entity.setPartitionId(record.getPartitionId());
        if (ProcessInstanceIntent.ELEMENT_COMPLETED.name().equals(record.getIntent().name())) {
            entity.setState(ProcessInstanceState.COMPLETED);
        } else if (ProcessInstanceIntent.ELEMENT_TERMINATED.name().equals(record.getIntent().name())) {
            entity.setState(ProcessInstanceState.CANCELED);
        }
        entity.setEndDate(DateUtil.toOffsetDateTime((Instant)Instant.ofEpochMilli(record.getTimestamp())));
        return entity;
    }

    private FlowNodeInstanceEntity createFlowNodeInstance(Record record) {
        ProcessInstanceRecordValueImpl recordValue = (ProcessInstanceRecordValueImpl)record.getValue();
        String intentStr = record.getIntent().name();
        FlowNodeInstanceEntity entity = new FlowNodeInstanceEntity();
        entity.setId(ConversionUtils.toStringOrNull((Object)record.getKey()));
        entity.setKey(record.getKey());
        entity.setPartitionId(record.getPartitionId());
        entity.setProcessInstanceId(String.valueOf(recordValue.getProcessInstanceKey()));
        entity.setParentFlowNodeId(String.valueOf(recordValue.getFlowScopeKey()));
        entity.setType(FlowNodeType.fromZeebeBpmnElementType(recordValue.getBpmnElementType() == null ? null : recordValue.getBpmnElementType().name()));
        entity.setPosition(Long.valueOf(record.getPosition()));
        if (ProcessInstanceIntent.ELEMENT_ACTIVATING.name().equals(intentStr)) {
            entity.setState(FlowNodeState.ACTIVE);
        } else if (ProcessInstanceIntent.ELEMENT_COMPLETED.name().equals(intentStr)) {
            entity.setState(FlowNodeState.COMPLETED);
        } else if (ProcessInstanceIntent.ELEMENT_TERMINATED.name().equals(intentStr)) {
            entity.setState(FlowNodeState.TERMINATED);
        }
        return entity;
    }

    private BulkOperation getFlowNodeInstanceQuery(FlowNodeInstanceEntity entity) {
        LOGGER.debug("Flow node instance: id {}", (Object)entity.getId());
        return (BulkOperation)new BulkOperation.Builder().index(IndexOperation.of(io -> ((IndexOperation.Builder)((IndexOperation.Builder)io.index(this.flowNodeInstanceIndex.getFullQualifiedName())).id(entity.getId())).document((Object)CommonUtils.getJsonObjectFromEntity((Object)entity)))).build();
    }

    private BulkOperation getProcessInstanceQuery(ProcessInstanceEntity entity) {
        LOGGER.debug("Process instance: id {}", (Object)entity.getId());
        return (BulkOperation)new BulkOperation.Builder().index(IndexOperation.of(io -> ((IndexOperation.Builder)((IndexOperation.Builder)io.index(this.processInstanceIndex.getFullQualifiedName())).id(entity.getId())).document((Object)CommonUtils.getJsonObjectFromEntity((Object)entity)))).build();
    }

    private boolean isVariableScopeType(ProcessInstanceRecordValueImpl recordValue) {
        BpmnElementType bpmnElementType = recordValue.getBpmnElementType();
        if (bpmnElementType == null) {
            return false;
        }
        return VARIABLE_SCOPE_TYPES.contains((Object)bpmnElementType);
    }

    private boolean isProcessEvent(ProcessInstanceRecordValueImpl recordValue) {
        return this.isOfType(recordValue, BpmnElementType.PROCESS);
    }

    private boolean isOfType(ProcessInstanceRecordValueImpl recordValue, BpmnElementType type) {
        BpmnElementType bpmnElementType = recordValue.getBpmnElementType();
        if (bpmnElementType == null) {
            return false;
        }
        return bpmnElementType.equals((Object)type);
    }
}

