/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.zeebeimport.v870.processors.es;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.tasklist.entities.FormEntity;
import io.camunda.tasklist.entities.ProcessEntity;
import io.camunda.tasklist.exceptions.PersistenceException;
import io.camunda.tasklist.schema.indices.FormIndex;
import io.camunda.tasklist.schema.indices.ProcessIndex;
import io.camunda.tasklist.util.ConversionUtils;
import io.camunda.tasklist.zeebeimport.common.ProcessDefinitionDeletionProcessor;
import io.camunda.tasklist.zeebeimport.util.XMLUtil;
import io.camunda.tasklist.zeebeimport.v870.record.value.deployment.DeployedProcessImpl;
import io.camunda.zeebe.protocol.v870.record.Record;
import io.camunda.zeebe.protocol.v870.record.intent.ProcessIntent;
import io.camunda.zeebe.protocol.v870.record.value.deployment.Process;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class ProcessZeebeRecordProcessorElasticSearch {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessZeebeRecordProcessorElasticSearch.class);
    private static final Set<String> STATES_TO_PERSIST = Set.of(ProcessIntent.CREATED.name());
    private static final Set<String> STATES_TO_DELETE = Set.of(ProcessIntent.DELETED.name());
    @Autowired
    @Qualifier(value="tasklistObjectMapper")
    private ObjectMapper objectMapper;
    @Autowired
    private ProcessIndex processIndex;
    @Autowired
    private FormIndex formIndex;
    @Autowired
    private XMLUtil xmlUtil;
    @Autowired
    private ProcessDefinitionDeletionProcessor processDefinitionDeletionProcessor;

    public void processDeploymentRecord(Record<DeployedProcessImpl> record, BulkRequest bulkRequest) throws PersistenceException {
        String intentStr = record.getIntent().name();
        DeployedProcessImpl recordValue = record.getValue();
        String processDefinitionKey = String.valueOf(record.getValue().getProcessDefinitionKey());
        if (STATES_TO_PERSIST.contains(intentStr)) {
            HashMap<String, String> userTaskForms = new HashMap<String, String>();
            this.persistProcess(recordValue, bulkRequest, userTaskForms::put);
            ArrayList exceptions = new ArrayList();
            userTaskForms.forEach((formKey, schema) -> {
                try {
                    this.persistForm(processDefinitionKey, (String)formKey, (String)schema, bulkRequest, recordValue.getTenantId());
                }
                catch (PersistenceException e) {
                    exceptions.add(e);
                }
            });
            if (!exceptions.isEmpty()) {
                throw (PersistenceException)((Object)exceptions.get(0));
            }
        } else if (STATES_TO_DELETE.contains(intentStr)) {
            bulkRequest.add((Iterable)this.processDefinitionDeletionProcessor.createProcessDefinitionDeleteRequests(processDefinitionKey, DeleteRequest::new));
        }
    }

    private void persistProcess(Process process, BulkRequest bulkRequest, BiConsumer<String, String> userTaskFormCollector) throws PersistenceException {
        ProcessEntity processEntity = this.createEntity(process, userTaskFormCollector);
        LOGGER.debug("Process: key {}", (Object)processEntity.getKey());
        try {
            bulkRequest.add(((IndexRequest)new IndexRequest().index(this.processIndex.getFullQualifiedName())).id(ConversionUtils.toStringOrNull((Object)processEntity.getKey())).source(this.objectMapper.writeValueAsString((Object)processEntity), XContentType.JSON));
        }
        catch (JsonProcessingException e) {
            throw new PersistenceException(String.format("Error preparing the query to insert process [%s]", processEntity.getKey()), (Throwable)e);
        }
    }

    private ProcessEntity createEntity(Process process, BiConsumer<String, String> userTaskFormCollector) {
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setId(String.valueOf(process.getProcessDefinitionKey()));
        processEntity.setKey(process.getProcessDefinitionKey());
        processEntity.setBpmnProcessId(process.getBpmnProcessId());
        processEntity.setVersion(Integer.valueOf(process.getVersion()));
        processEntity.setTenantId(process.getTenantId());
        processEntity.setBpmnXml(new String(process.getResource()));
        byte[] byteArray = process.getResource();
        this.xmlUtil.extractDiagramData(byteArray, process.getBpmnProcessId()::equals, arg_0 -> ((ProcessEntity)processEntity).setName(arg_0), flowNode -> processEntity.getFlowNodes().add(flowNode), userTaskFormCollector, arg_0 -> ((ProcessEntity)processEntity).setFormKey(arg_0), formId -> processEntity.setFormId(formId), arg_0 -> ((ProcessEntity)processEntity).setStartedByForm(arg_0));
        Optional.ofNullable(processEntity.getFormKey()).ifPresent(key -> processEntity.setIsFormEmbedded(Boolean.valueOf(true)));
        Optional.ofNullable(processEntity.getFormId()).ifPresent(id -> processEntity.setIsFormEmbedded(Boolean.valueOf(false)));
        return processEntity;
    }

    private void persistForm(String processDefinitionKey, String formKey, String schema, BulkRequest bulkRequest, String tenantId) throws PersistenceException {
        FormEntity formEntity = new FormEntity(processDefinitionKey, formKey, schema, tenantId);
        LOGGER.debug("Form: key {}", (Object)formKey);
        try {
            bulkRequest.add(((IndexRequest)new IndexRequest().index(this.formIndex.getFullQualifiedName())).id(ConversionUtils.toStringOrNull((Object)formEntity.getId())).source(this.objectMapper.writeValueAsString((Object)formEntity), XContentType.JSON));
        }
        catch (JsonProcessingException e) {
            throw new PersistenceException(String.format("Error preparing the query to insert task form [%s]", formEntity.getId()), (Throwable)e);
        }
    }
}

