/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.zeebeimport.v870.processors.es;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.tasklist.entities.FormEntity;
import io.camunda.tasklist.exceptions.PersistenceException;
import io.camunda.tasklist.schema.indices.FormIndex;
import io.camunda.tasklist.util.ConversionUtils;
import io.camunda.tasklist.zeebeimport.v870.record.value.deployment.FormRecordImpl;
import io.camunda.zeebe.protocol.v870.record.Record;
import io.camunda.zeebe.protocol.v870.record.intent.FormIntent;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class FormZeebeRecordProcessorElasticSearch {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormZeebeRecordProcessorElasticSearch.class);
    @Autowired
    @Qualifier(value="tasklistObjectMapper")
    private ObjectMapper objectMapper;
    @Autowired
    private FormIndex formIndex;

    public void processFormRecord(Record record, BulkRequest bulkRequest) throws PersistenceException {
        FormRecordImpl recordValue = (FormRecordImpl)record.getValue();
        if (record.getIntent().name().equals(FormIntent.CREATED.name())) {
            this.persistForm(recordValue.getFormKey(), FormZeebeRecordProcessorElasticSearch.bytesToXml(recordValue.getResource()), Long.valueOf(recordValue.getVersion()), recordValue.getTenantId(), recordValue.getFormId(), false, bulkRequest);
        } else if (record.getIntent().name().equals(FormIntent.DELETED.name())) {
            this.persistForm(recordValue.getFormKey(), FormZeebeRecordProcessorElasticSearch.bytesToXml(recordValue.getResource()), Long.valueOf(recordValue.getVersion()), recordValue.getTenantId(), recordValue.getFormId(), true, bulkRequest);
        } else {
            LOGGER.info("Form intent {} not supported", (Object)record.getIntent().name());
        }
    }

    private void persistForm(Long formKey, String schema, Long version, String tenantId, String formId, boolean isDelete, BulkRequest bulkRequest) throws PersistenceException {
        FormEntity formEntity = new FormEntity(null, formId, schema, version, tenantId, formKey.toString(), Boolean.valueOf(false), Boolean.valueOf(false));
        try {
            if (isDelete) {
                bulkRequest.add(((UpdateRequest)new UpdateRequest().index(this.formIndex.getFullQualifiedName())).id(formEntity.getId()).upsert(this.objectMapper.writeValueAsString((Object)formEntity), XContentType.JSON).doc(Map.of("isDeleted", true)).retryOnConflict(3));
            } else {
                bulkRequest.add(((IndexRequest)new IndexRequest().index(this.formIndex.getFullQualifiedName())).id(ConversionUtils.toStringOrNull((Object)formEntity.getId())).source(this.objectMapper.writeValueAsString((Object)formEntity), XContentType.JSON));
            }
        }
        catch (JsonProcessingException e) {
            throw new PersistenceException(String.format("Error preparing the form query for the formId: [%s]", formEntity.getId()), (Throwable)e);
        }
    }

    public static String bytesToXml(byte[] bytes) {
        return new String(bytes, StandardCharsets.UTF_8);
    }
}

