/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.zeebeimport.v870.processors.common;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.tasklist.entities.TaskVariableEntity;
import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import io.camunda.tasklist.property.TasklistProperties;
import io.camunda.tasklist.zeebeimport.v870.processors.common.UserTaskRecordToTaskEntityMapper;
import io.camunda.tasklist.zeebeimport.v870.record.Intent;
import io.camunda.zeebe.protocol.v870.record.Record;
import io.camunda.zeebe.protocol.v870.record.value.UserTaskRecordValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class UserTaskRecordToVariableEntityMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserTaskRecordToTaskEntityMapper.class);
    @Autowired
    private TasklistProperties tasklistProperties;
    @Autowired
    @Qualifier(value="tasklistObjectMapper")
    private ObjectMapper objectMapper;

    public List<TaskVariableEntity> mapVariables(Record<UserTaskRecordValue> record) {
        ArrayList<TaskVariableEntity> variables = new ArrayList<TaskVariableEntity>();
        if (record.getIntent().equals(Intent.COMPLETED)) {
            UserTaskRecordValue recordValue = record.getValue();
            Map<String, Object> variablesMap = recordValue.getVariables();
            for (Map.Entry<String, Object> varMap : variablesMap.entrySet()) {
                String varValue;
                try {
                    varValue = this.objectMapper.writeValueAsString(varMap.getValue());
                }
                catch (JsonProcessingException e) {
                    throw new TasklistRuntimeException("Failed to parse variable %s".formatted(varMap), (Throwable)e);
                }
                TaskVariableEntity variableEntity = new TaskVariableEntity();
                variableEntity.setId(TaskVariableEntity.getIdBy((String)String.valueOf(recordValue.getUserTaskKey()), (String)varMap.getKey()));
                variableEntity.setName(varMap.getKey());
                variableEntity.setTaskId(String.valueOf(recordValue.getUserTaskKey()));
                variableEntity.setPartitionId(record.getPartitionId());
                variableEntity.setTenantId(recordValue.getTenantId());
                variableEntity.setFullValue(varValue);
                if (varValue.length() > this.tasklistProperties.getImporter().getVariableSizeThreshold()) {
                    variableEntity.setValue(varValue.substring(0, this.tasklistProperties.getImporter().getVariableSizeThreshold()));
                    variableEntity.setIsPreview(true);
                } else {
                    variableEntity.setValue(varValue);
                }
                variables.add(variableEntity);
            }
        }
        return variables;
    }
}

