/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.zeebeimport.v870.processors.os;

import io.camunda.tasklist.CommonUtils;
import io.camunda.tasklist.entities.FormEntity;
import io.camunda.tasklist.exceptions.PersistenceException;
import io.camunda.tasklist.schema.indices.FormIndex;
import io.camunda.tasklist.util.ConversionUtils;
import io.camunda.tasklist.zeebeimport.v870.record.value.deployment.FormRecordImpl;
import io.camunda.zeebe.protocol.v870.record.Record;
import io.camunda.zeebe.protocol.v870.record.intent.FormIntent;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.opensearch.client.opensearch.core.bulk.BulkOperation;
import org.opensearch.client.opensearch.core.bulk.IndexOperation;
import org.opensearch.client.opensearch.core.bulk.UpdateOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FormZeebeRecordProcessorOpenSearch {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormZeebeRecordProcessorOpenSearch.class);
    @Autowired
    private FormIndex formIndex;

    public void processFormRecord(Record record, List<BulkOperation> operations) throws PersistenceException {
        FormRecordImpl recordValue = (FormRecordImpl)record.getValue();
        if (record.getIntent().name().equals(FormIntent.CREATED.name())) {
            this.persistForm(recordValue.getFormKey(), FormZeebeRecordProcessorOpenSearch.bytesToXml(recordValue.getResource()), Long.valueOf(recordValue.getVersion()), recordValue.getTenantId(), recordValue.getFormId(), false, operations);
        } else if (record.getIntent().name().equals(FormIntent.DELETED.name())) {
            this.persistForm(recordValue.getFormKey(), FormZeebeRecordProcessorOpenSearch.bytesToXml(recordValue.getResource()), Long.valueOf(recordValue.getVersion()), recordValue.getTenantId(), recordValue.getFormId(), true, operations);
        } else {
            LOGGER.info("Form intent {} not supported", (Object)record.getIntent().name());
        }
    }

    private void persistForm(Long formKey, String schema, Long version, String tenantId, String formId, boolean isDelete, List<BulkOperation> operations) throws PersistenceException {
        FormEntity formEntity = new FormEntity(null, formId, schema, version, tenantId, formKey.toString(), Boolean.valueOf(false), Boolean.valueOf(isDelete));
        try {
            if (isDelete) {
                BulkOperation bulkOperation = (BulkOperation)new BulkOperation.Builder().update(up -> ((UpdateOperation.Builder)((UpdateOperation.Builder)up.index(this.formIndex.getFullQualifiedName())).id(formEntity.getId())).document((Object)CommonUtils.getJsonObjectFromEntity((Object)formEntity)).docAsUpsert(Boolean.valueOf(true)).retryOnConflict(Integer.valueOf(3))).build();
                operations.add(bulkOperation);
            } else {
                operations.add((BulkOperation)new BulkOperation.Builder().index(IndexOperation.of(io -> ((IndexOperation.Builder)((IndexOperation.Builder)io.index(this.formIndex.getFullQualifiedName())).id(ConversionUtils.toStringOrNull((Object)formEntity.getId()))).document((Object)CommonUtils.getJsonObjectFromEntity((Object)formEntity)))).build());
            }
        }
        catch (Exception e) {
            throw new PersistenceException(String.format("Error preparing the form query for the formId: [%s]", formEntity.getId()), (Throwable)e);
        }
    }

    public static String bytesToXml(byte[] bytes) {
        return new String(bytes, StandardCharsets.UTF_8);
    }
}

