/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.zeebeimport.v870.processors.es;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.tasklist.entities.VariableEntity;
import io.camunda.tasklist.exceptions.PersistenceException;
import io.camunda.tasklist.property.TasklistProperties;
import io.camunda.tasklist.schema.indices.VariableIndex;
import io.camunda.tasklist.zeebeimport.v870.record.Intent;
import io.camunda.tasklist.zeebeimport.v870.record.value.VariableRecordValueImpl;
import io.camunda.zeebe.protocol.v870.record.Record;
import java.io.IOException;
import java.util.HashMap;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class VariableZeebeRecordProcessorElasticSearch {
    private static final Logger LOGGER = LoggerFactory.getLogger(VariableZeebeRecordProcessorElasticSearch.class);
    @Autowired
    @Qualifier(value="tasklistObjectMapper")
    private ObjectMapper objectMapper;
    @Autowired
    private VariableIndex variableIndex;
    @Autowired
    private TasklistProperties tasklistProperties;

    public void processVariableRecord(Record record, BulkRequest bulkRequest) throws PersistenceException {
        VariableRecordValueImpl recordValue = (VariableRecordValueImpl)record.getValue();
        if (record.getIntent().name() != Intent.MIGRATED.name()) {
            bulkRequest.add(this.persistVariable(record, recordValue));
        }
    }

    private UpdateRequest persistVariable(Record record, VariableRecordValueImpl recordValue) throws PersistenceException {
        VariableEntity variableEntity = this.getVariableEntity(record, recordValue);
        return this.getVariableQuery(variableEntity);
    }

    private UpdateRequest getVariableQuery(VariableEntity entity) throws PersistenceException {
        try {
            LOGGER.debug("Variable instance for list view: id {}", (Object)entity.getId());
            HashMap<String, Object> updateFields = new HashMap<String, Object>();
            updateFields.put("value", entity.getValue());
            updateFields.put("fullValue", entity.getFullValue());
            updateFields.put("isPreview", entity.getIsPreview());
            return ((UpdateRequest)new UpdateRequest().index(this.variableIndex.getFullQualifiedName())).id(entity.getId()).upsert(this.objectMapper.writeValueAsString((Object)entity), XContentType.JSON).doc(updateFields).retryOnConflict(3);
        }
        catch (IOException e) {
            throw new PersistenceException(String.format("Error preparing the query to upsert variable instance [%s]  for list view", entity.getId()), (Throwable)e);
        }
    }

    private VariableEntity getVariableEntity(Record record, VariableRecordValueImpl recordValue) {
        VariableEntity entity = new VariableEntity();
        entity.setId(VariableEntity.getIdBy((String)String.valueOf(recordValue.getScopeKey()), (String)recordValue.getName()));
        entity.setKey(record.getKey());
        entity.setPartitionId(record.getPartitionId());
        entity.setScopeFlowNodeId(String.valueOf(recordValue.getScopeKey()));
        entity.setProcessInstanceId(String.valueOf(recordValue.getProcessInstanceKey()));
        entity.setName(recordValue.getName());
        entity.setTenantId(recordValue.getTenantId());
        if (recordValue.getValue().length() > this.tasklistProperties.getImporter().getVariableSizeThreshold()) {
            entity.setValue(recordValue.getValue().substring(0, this.tasklistProperties.getImporter().getVariableSizeThreshold()));
            entity.setIsPreview(true);
        } else {
            entity.setValue(recordValue.getValue());
        }
        entity.setFullValue(recordValue.getValue());
        return entity;
    }
}

