/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.v870.record;

import io.camunda.zeebe.protocol.v870.record.MessageHeaderDecoder;
import io.camunda.zeebe.protocol.v870.record.MetaAttribute;
import io.camunda.zeebe.protocol.v870.record.RecordType;
import io.camunda.zeebe.protocol.v870.record.RejectionType;
import io.camunda.zeebe.protocol.v870.record.ValueType;
import io.camunda.zeebe.protocol.v870.record.VersionDecoder;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.MessageDecoderFlyweight;

public final class RecordMetadataDecoder
implements MessageDecoderFlyweight {
    public static final int BLOCK_LENGTH = 40;
    public static final int TEMPLATE_ID = 200;
    public static final int SCHEMA_ID = 0;
    public static final int SCHEMA_VERSION = 5;
    public static final String SEMANTIC_VERSION = "8.7.10";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final RecordMetadataDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;
    private final VersionDecoder brokerVersion = new VersionDecoder();

    public int sbeBlockLength() {
        return 40;
    }

    public int sbeTemplateId() {
        return 200;
    }

    public int sbeSchemaId() {
        return 0;
    }

    public int sbeSchemaVersion() {
        return 5;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public RecordMetadataDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public RecordMetadataDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (200 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public RecordMetadataDecoder sbeRewind() {
        return this.wrap(this.buffer, this.offset, this.actingBlockLength, this.actingVersion);
    }

    public int sbeDecodedLength() {
        int currentLimit = this.limit();
        this.sbeSkip();
        int decodedLength = this.encodedLength();
        this.limit(currentLimit);
        return decodedLength;
    }

    public int actingVersion() {
        return this.actingVersion;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int recordTypeId() {
        return 1;
    }

    public static int recordTypeSinceVersion() {
        return 0;
    }

    public static int recordTypeEncodingOffset() {
        return 0;
    }

    public static int recordTypeEncodingLength() {
        return 1;
    }

    public static String recordTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public short recordTypeRaw() {
        return (short)(this.buffer.getByte(this.offset + 0) & 0xFF);
    }

    public RecordType recordType() {
        return RecordType.get((short)(this.buffer.getByte(this.offset + 0) & 0xFF));
    }

    public static int requestStreamIdId() {
        return 2;
    }

    public static int requestStreamIdSinceVersion() {
        return 0;
    }

    public static int requestStreamIdEncodingOffset() {
        return 1;
    }

    public static int requestStreamIdEncodingLength() {
        return 4;
    }

    public static String requestStreamIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int requestStreamIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int requestStreamIdMinValue() {
        return -2147483647;
    }

    public static int requestStreamIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int requestStreamId() {
        return this.buffer.getInt(this.offset + 1, BYTE_ORDER);
    }

    public static int requestIdId() {
        return 3;
    }

    public static int requestIdSinceVersion() {
        return 0;
    }

    public static int requestIdEncodingOffset() {
        return 5;
    }

    public static int requestIdEncodingLength() {
        return 8;
    }

    public static String requestIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long requestIdNullValue() {
        return -1L;
    }

    public static long requestIdMinValue() {
        return 0L;
    }

    public static long requestIdMaxValue() {
        return -2L;
    }

    public long requestId() {
        return this.buffer.getLong(this.offset + 5, BYTE_ORDER);
    }

    public static int protocolVersionId() {
        return 4;
    }

    public static int protocolVersionSinceVersion() {
        return 0;
    }

    public static int protocolVersionEncodingOffset() {
        return 13;
    }

    public static int protocolVersionEncodingLength() {
        return 2;
    }

    public static String protocolVersionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int protocolVersionNullValue() {
        return 65535;
    }

    public static int protocolVersionMinValue() {
        return 0;
    }

    public static int protocolVersionMaxValue() {
        return 65534;
    }

    public int protocolVersion() {
        return this.buffer.getShort(this.offset + 13, BYTE_ORDER) & 0xFFFF;
    }

    public static int valueTypeId() {
        return 5;
    }

    public static int valueTypeSinceVersion() {
        return 0;
    }

    public static int valueTypeEncodingOffset() {
        return 15;
    }

    public static int valueTypeEncodingLength() {
        return 1;
    }

    public static String valueTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public short valueTypeRaw() {
        return (short)(this.buffer.getByte(this.offset + 15) & 0xFF);
    }

    public ValueType valueType() {
        return ValueType.get((short)(this.buffer.getByte(this.offset + 15) & 0xFF));
    }

    public static int intentId() {
        return 6;
    }

    public static int intentSinceVersion() {
        return 0;
    }

    public static int intentEncodingOffset() {
        return 16;
    }

    public static int intentEncodingLength() {
        return 1;
    }

    public static String intentMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static short intentNullValue() {
        return 255;
    }

    public static short intentMinValue() {
        return 0;
    }

    public static short intentMaxValue() {
        return 254;
    }

    public short intent() {
        return (short)(this.buffer.getByte(this.offset + 16) & 0xFF);
    }

    public static int brokerVersionId() {
        return 9;
    }

    public static int brokerVersionSinceVersion() {
        return 2;
    }

    public static int brokerVersionEncodingOffset() {
        return 17;
    }

    public static int brokerVersionEncodingLength() {
        return 12;
    }

    public static String brokerVersionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public VersionDecoder brokerVersion() {
        if (this.parentMessage.actingVersion < 2) {
            return null;
        }
        this.brokerVersion.wrap(this.buffer, this.offset + 17);
        return this.brokerVersion;
    }

    public static int recordVersionId() {
        return 10;
    }

    public static int recordVersionSinceVersion() {
        return 3;
    }

    public static int recordVersionEncodingOffset() {
        return 29;
    }

    public static int recordVersionEncodingLength() {
        return 2;
    }

    public static String recordVersionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public static int recordVersionNullValue() {
        return 65535;
    }

    public static int recordVersionMinValue() {
        return 0;
    }

    public static int recordVersionMaxValue() {
        return 65534;
    }

    public int recordVersion() {
        if (this.parentMessage.actingVersion < 3) {
            return 65535;
        }
        return this.buffer.getShort(this.offset + 29, BYTE_ORDER) & 0xFFFF;
    }

    public static int rejectionTypeId() {
        return 7;
    }

    public static int rejectionTypeSinceVersion() {
        return 0;
    }

    public static int rejectionTypeEncodingOffset() {
        return 31;
    }

    public static int rejectionTypeEncodingLength() {
        return 1;
    }

    public static String rejectionTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public short rejectionTypeRaw() {
        return (short)(this.buffer.getByte(this.offset + 31) & 0xFF);
    }

    public RejectionType rejectionType() {
        return RejectionType.get((short)(this.buffer.getByte(this.offset + 31) & 0xFF));
    }

    public static int operationReferenceId() {
        return 12;
    }

    public static int operationReferenceSinceVersion() {
        return 5;
    }

    public static int operationReferenceEncodingOffset() {
        return 32;
    }

    public static int operationReferenceEncodingLength() {
        return 8;
    }

    public static String operationReferenceMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public static long operationReferenceNullValue() {
        return -1L;
    }

    public static long operationReferenceMinValue() {
        return 0L;
    }

    public static long operationReferenceMaxValue() {
        return -2L;
    }

    public long operationReference() {
        if (this.parentMessage.actingVersion < 5) {
            return -1L;
        }
        return this.buffer.getLong(this.offset + 32, BYTE_ORDER);
    }

    public static int rejectionReasonId() {
        return 8;
    }

    public static int rejectionReasonSinceVersion() {
        return 0;
    }

    public static String rejectionReasonCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String rejectionReasonMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int rejectionReasonHeaderLength() {
        return 4;
    }

    public int rejectionReasonLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
    }

    public int skipRejectionReason() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getRejectionReason(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getRejectionReason(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapRejectionReason(DirectBuffer wrapBuffer) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
    }

    public String rejectionReason() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        return new String(tmp, StandardCharsets.UTF_8);
    }

    public static int authorizationId() {
        return 11;
    }

    public static int authorizationSinceVersion() {
        return 4;
    }

    public static String authorizationCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String authorizationMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int authorizationHeaderLength() {
        return 4;
    }

    public int authorizationLength() {
        if (this.parentMessage.actingVersion < 4) {
            return 0;
        }
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
    }

    public int skipAuthorization() {
        if (this.parentMessage.actingVersion < 4) {
            return 0;
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getAuthorization(MutableDirectBuffer dst, int dstOffset, int length) {
        if (this.parentMessage.actingVersion < 4) {
            return 0;
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getAuthorization(byte[] dst, int dstOffset, int length) {
        if (this.parentMessage.actingVersion < 4) {
            return 0;
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapAuthorization(DirectBuffer wrapBuffer) {
        if (this.parentMessage.actingVersion < 4) {
            wrapBuffer.wrap(this.buffer, this.offset, 0);
            return;
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
    }

    public String authorization() {
        if (this.parentMessage.actingVersion < 4) {
            return "";
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        return new String(tmp, StandardCharsets.UTF_8);
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        RecordMetadataDecoder decoder = new RecordMetadataDecoder();
        decoder.wrap(this.buffer, this.offset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.offset + this.actingBlockLength);
        builder.append("[RecordMetadata](sbeTemplateId=");
        builder.append(200);
        builder.append("|sbeSchemaId=");
        builder.append(0);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 5) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(5);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 40) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(40);
        builder.append("):");
        builder.append("recordType=");
        builder.append((Object)this.recordType());
        builder.append('|');
        builder.append("requestStreamId=");
        builder.append(this.requestStreamId());
        builder.append('|');
        builder.append("requestId=");
        builder.append(this.requestId());
        builder.append('|');
        builder.append("protocolVersion=");
        builder.append(this.protocolVersion());
        builder.append('|');
        builder.append("valueType=");
        builder.append((Object)this.valueType());
        builder.append('|');
        builder.append("intent=");
        builder.append(this.intent());
        builder.append('|');
        builder.append("brokerVersion=");
        VersionDecoder brokerVersion = this.brokerVersion();
        if (null != brokerVersion) {
            brokerVersion.appendTo(builder);
        } else {
            builder.append("null");
        }
        builder.append('|');
        builder.append("recordVersion=");
        builder.append(this.recordVersion());
        builder.append('|');
        builder.append("rejectionType=");
        builder.append((Object)this.rejectionType());
        builder.append('|');
        builder.append("operationReference=");
        builder.append(this.operationReference());
        builder.append('|');
        builder.append("rejectionReason=");
        builder.append('\'').append(this.rejectionReason()).append('\'');
        builder.append('|');
        builder.append("authorization=");
        builder.append('\'').append(this.authorization()).append('\'');
        this.limit(originalLimit);
        return builder;
    }

    public RecordMetadataDecoder sbeSkip() {
        this.sbeRewind();
        this.skipRejectionReason();
        this.skipAuthorization();
        return this;
    }
}

