/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.archiver.es;

import io.camunda.tasklist.archiver.ArchiverUtilAbstract;
import io.camunda.tasklist.data.conditionals.ElasticSearchCondition;
import io.camunda.tasklist.exceptions.ArchiverException;
import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import io.camunda.tasklist.util.Either;
import io.camunda.tasklist.util.ElasticsearchUtil;
import io.micrometer.core.instrument.Timer;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.AbstractBulkByScrollRequest;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.index.reindex.ReindexRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class ArchiverUtilElasticSearch
extends ArchiverUtilAbstract {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArchiverUtilElasticSearch.class);
    @Autowired
    @Qualifier(value="tasklistEsClient")
    private RestHighLevelClient esClient;

    @Override
    public CompletableFuture<Long> deleteDocuments(String sourceIndexName, String idFieldName, List<String> processInstanceKeys) {
        CompletableFuture<Long> deleteFuture = new CompletableFuture<Long>();
        DeleteByQueryRequest deleteRequest = (DeleteByQueryRequest)this.createDeleteByQueryRequestWithDefaults(sourceIndexName).setQuery((QueryBuilder)QueryBuilders.termsQuery((String)idFieldName, processInstanceKeys)).setMaxRetries(3);
        Timer.Sample startTimer = Timer.start();
        this.sendDeleteRequest(deleteRequest).whenComplete((response, e) -> {
            Timer timer = this.getArchiverDeleteQueryTimer();
            startTimer.stop(timer);
            if (e != null) {
                this.trackMetricForDeleteFailures(processInstanceKeys, (Throwable)e);
            }
            Either<Throwable, Long> result = this.handleResponse((BulkByScrollResponse)response, (Throwable)e, sourceIndexName, "delete");
            result.ifRightOrLeft(deleteFuture::complete, deleteFuture::completeExceptionally);
        });
        return deleteFuture;
    }

    @Override
    public CompletableFuture<Long> reindexDocuments(String sourceIndexName, String destinationIndexName, String idFieldName, List<String> processInstanceKeys) {
        CompletableFuture<Long> reindexFuture = new CompletableFuture<Long>();
        ReindexRequest reindexRequest = this.createReindexRequestWithDefaults().setSourceIndices(new String[]{sourceIndexName}).setDestIndex(destinationIndexName).setSourceQuery((QueryBuilder)QueryBuilders.termsQuery((String)idFieldName, processInstanceKeys));
        Timer.Sample startTimer = Timer.start();
        this.sendReindexRequest(reindexRequest).whenComplete((response, e) -> {
            Timer reindexTimer = this.getArchiverReindexQueryTimer();
            startTimer.stop(reindexTimer);
            if (e != null) {
                this.trackMetricForReindexFailures(processInstanceKeys, (Throwable)e);
            }
            Either<Throwable, Long> result = this.handleResponse((BulkByScrollResponse)response, (Throwable)e, sourceIndexName, "reindex");
            result.ifRightOrLeft(reindexFuture::complete, reindexFuture::completeExceptionally);
        });
        return reindexFuture;
    }

    @Override
    public void setIndexLifeCycle(String destinationIndexName) {
        try {
            if (this.tasklistProperties.getArchiver().isIlmEnabled()) {
                this.esClient.indices().putSettings(new UpdateSettingsRequest(new String[]{destinationIndexName}).settings(Settings.builder().put("index.lifecycle.name", "tasklist_delete_archived_indices").build()), RequestOptions.DEFAULT);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Could not set ILM policy {} for index {}: {}", new Object[]{"tasklist_delete_archived_indices", destinationIndexName, e.getMessage()});
        }
    }

    private CompletableFuture<BulkByScrollResponse> sendReindexRequest(ReindexRequest reindexRequest) {
        return ElasticsearchUtil.reindexAsync((ReindexRequest)reindexRequest, (Executor)this.archiverExecutor, (RestHighLevelClient)this.esClient);
    }

    private ReindexRequest createReindexRequestWithDefaults() {
        ReindexRequest reindexRequest = new ReindexRequest();
        return this.applyDefaultSettings(reindexRequest);
    }

    private DeleteByQueryRequest createDeleteByQueryRequestWithDefaults(String index) {
        DeleteByQueryRequest deleteRequest = new DeleteByQueryRequest(new String[]{index});
        return this.applyDefaultSettings(deleteRequest);
    }

    private CompletableFuture<BulkByScrollResponse> sendDeleteRequest(DeleteByQueryRequest deleteRequest) {
        return ElasticsearchUtil.deleteByQueryAsync((DeleteByQueryRequest)deleteRequest, (Executor)this.archiverExecutor, (RestHighLevelClient)this.esClient);
    }

    private <T extends AbstractBulkByScrollRequest<T>> T applyDefaultSettings(T request) {
        return (T)request.setScroll(TimeValue.timeValueMillis((long)30000L)).setAbortOnVersionConflict(false).setSlices(0);
    }

    private Either<Throwable, Long> handleResponse(BulkByScrollResponse response, Throwable error, String sourceIndexName, String operation) {
        if (error != null) {
            String message = String.format("Exception occurred, while performing operation %s on source index %s. the documents: %s", operation, sourceIndexName, error.getMessage());
            return Either.left((Object)new TasklistRuntimeException(message, error));
        }
        List bulkFailures = response.getBulkFailures();
        if (bulkFailures.size() > 0) {
            LOGGER.error("Failures occurred when performing operation: {} on source index {}. See details below.", (Object)operation, (Object)sourceIndexName);
            bulkFailures.stream().forEach(f -> LOGGER.error(f.toString()));
            return Either.left((Object)new ArchiverException(String.format("Operation % failed", operation)));
        }
        LOGGER.debug("Operation {} succeded on source index {}. Response: {}", new Object[]{operation, sourceIndexName, response.toString()});
        return Either.right((Object)response.getTotal());
    }

    private Timer getArchiverReindexQueryTimer() {
        return this.metrics.getTimer("tasklist.archiver.reindex.query", new String[0]);
    }

    private void trackMetricForReindexFailures(List<String> processInstanceKeys, Throwable e) {
        LOGGER.error("Failed reindex while trying to reindex the following process instance keys [{}]", processInstanceKeys);
        this.metrics.recordCounts("archival.reindex.failures", 1L, new String[]{"exception", e.getCause().getClass().getSimpleName()});
    }

    private void trackMetricForDeleteFailures(List<String> processInstanceKeys, Throwable e) {
        LOGGER.error("Failed deletion while trying to archive the following process instance keys [{}]", processInstanceKeys);
        this.metrics.recordCounts("archival.delete.failures", 1L, new String[]{"exception", e.getCause().getClass().getSimpleName()});
    }

    private Timer getArchiverDeleteQueryTimer() {
        return this.metrics.getTimer("tasklist.archiver.delete.query", new String[0]);
    }
}

