/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.archiver.os;

import io.camunda.tasklist.Metrics;
import io.camunda.tasklist.archiver.AbstractArchiverJob;
import io.camunda.tasklist.archiver.TaskArchiverJob;
import io.camunda.tasklist.archiver.os.AbstractArchiverJobOpenSearch;
import io.camunda.tasklist.data.conditionals.OpenSearchCondition;
import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import io.camunda.tasklist.property.TasklistProperties;
import io.camunda.tasklist.schema.templates.TaskTemplate;
import io.camunda.tasklist.schema.templates.TaskVariableTemplate;
import io.camunda.tasklist.util.Either;
import io.camunda.tasklist.util.OpenSearchUtil;
import io.micrometer.core.instrument.Timer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch._types.FieldSort;
import org.opensearch.client.opensearch._types.FieldValue;
import org.opensearch.client.opensearch._types.SortOrder;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.Buckets;
import org.opensearch.client.opensearch._types.aggregations.CalendarInterval;
import org.opensearch.client.opensearch._types.aggregations.DateHistogramAggregate;
import org.opensearch.client.opensearch._types.aggregations.DateHistogramBucket;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.opensearch.client.opensearch.core.search.Hit;
import org.opensearch.client.opensearch.core.search.HitsMetadata;
import org.opensearch.client.util.ObjectBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@Conditional(value={OpenSearchCondition.class})
public class TaskArchiverJobOpenSearch
extends AbstractArchiverJobOpenSearch
implements TaskArchiverJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskArchiverJobOpenSearch.class);
    private static final String DATES_AGG = "datesAgg";
    private static final String INSTANCES_AGG = "instancesAgg";
    @Autowired
    private TaskTemplate taskTemplate;
    @Autowired
    private TaskVariableTemplate taskVariableTemplate;
    @Autowired
    private TasklistProperties tasklistProperties;
    @Qualifier(value="tasklistOsClient")
    @Autowired
    private OpenSearchClient osClient;
    @Autowired
    private Metrics metrics;

    public TaskArchiverJobOpenSearch(List<Integer> partitionIds) {
        super(partitionIds);
    }

    @Override
    public CompletableFuture<Map.Entry<String, Integer>> archiveBatch(AbstractArchiverJob.ArchiveBatch archiveBatch) {
        CompletableFuture<Map.Entry<String, Integer>> archiveBatchFuture;
        if (archiveBatch != null) {
            LOGGER.debug("Following batch operations are found for archiving: {}", (Object)archiveBatch);
            archiveBatchFuture = new CompletableFuture();
            CompletableFuture<Void> moveVariableDocuments = this.archiverUtil.moveDocuments(this.taskVariableTemplate.getFullQualifiedName(), "taskId", archiveBatch.getFinishDate(), archiveBatch.getIds());
            CompletableFuture<Void> moveTaskDocuments = this.archiverUtil.moveDocuments(this.taskTemplate.getFullQualifiedName(), "id", archiveBatch.getFinishDate(), archiveBatch.getIds());
            ((CompletableFuture)CompletableFuture.allOf(moveVariableDocuments, moveTaskDocuments).thenAccept(v -> archiveBatchFuture.complete(Map.entry(archiveBatch.getFinishDate(), archiveBatch.getIds().size())))).exceptionally(exception -> {
                archiveBatchFuture.completeExceptionally((Throwable)exception);
                return null;
            });
        } else {
            LOGGER.debug("Nothing to archive");
            archiveBatchFuture = CompletableFuture.completedFuture(Map.entry("NothingToArchive", 0));
        }
        return archiveBatchFuture;
    }

    @Override
    public CompletableFuture<AbstractArchiverJob.ArchiveBatch> getNextBatch() {
        CompletableFuture<AbstractArchiverJob.ArchiveBatch> batchFuture = new CompletableFuture<AbstractArchiverJob.ArchiveBatch>();
        Aggregation aggregation = this.createFinishedTasksAggregation(DATES_AGG, INSTANCES_AGG);
        SearchRequest searchRequest = this.createFinishedTasksSearchRequest(aggregation);
        Timer.Sample startTimer = Timer.start();
        this.sendSearchRequest(searchRequest).whenComplete((response, e) -> {
            Timer timer = this.getArchiverQueryTimer();
            startTimer.stop(timer);
            Either<Throwable, AbstractArchiverJob.ArchiveBatch> result = this.handleSearchResponse((SearchResponse)response, (Throwable)e);
            result.ifRightOrLeft(batchFuture::complete, batchFuture::completeExceptionally);
        });
        return batchFuture;
    }

    protected Either<Throwable, AbstractArchiverJob.ArchiveBatch> handleSearchResponse(SearchResponse searchResponse, Throwable error) {
        if (error != null) {
            String message = String.format("Exception occurred, while obtaining finished batch operations: %s", error.getMessage());
            return Either.left((Object)new TasklistRuntimeException(message, error));
        }
        AbstractArchiverJob.ArchiveBatch batch = this.createArchiveBatch(searchResponse);
        return Either.right((Object)batch);
    }

    private SearchRequest createFinishedTasksSearchRequest(Aggregation agg) {
        List partitions = this.getPartitionIds().stream().map(m -> FieldValue.of((long)m.intValue())).collect(Collectors.toList());
        SearchRequest.Builder builder = new SearchRequest.Builder();
        Query.Builder endDateQ = new Query.Builder();
        endDateQ.range(r -> r.field("completionTime").lte(JsonData.of((Object)this.tasklistProperties.getArchiver().getArchivingTimepoint())));
        Query.Builder partitionQ = new Query.Builder();
        partitionQ.terms(terms -> terms.field("partitionId").terms(values -> values.value(partitions)));
        Query q = (Query)new Query.Builder().constantScore(cs -> cs.filter(OpenSearchUtil.joinWithAnd((ObjectBuilder[])new ObjectBuilder[]{endDateQ, partitionQ}))).build();
        builder.index(this.taskTemplate.getFullQualifiedName(), new String[0]).query(q).sort(s -> s.field(FieldSort.of(f -> f.field("completionTime").order(SortOrder.Asc)))).aggregations(DATES_AGG, agg).size(Integer.valueOf(0)).requestCache(Boolean.valueOf(false));
        LOGGER.debug("Finished tasks for archiving request: \n{}\n and aggregation: \n{}", (Object)q.toString(), (Object)agg.toString());
        return builder.build();
    }

    private CalendarInterval calendarIntervalByAlias(String alias) {
        return Arrays.stream(CalendarInterval.values()).filter(ci -> Arrays.asList(ci.aliases()).contains(alias)).findFirst().orElseThrow(() -> {
            List legalAliases = Arrays.stream(CalendarInterval.values()).flatMap(v -> Arrays.stream(v.aliases())).sorted().toList();
            return new TasklistRuntimeException(String.format("Unknown CalendarInterval alias %s! Legal aliases: %s", alias, legalAliases));
        });
    }

    private Aggregation createFinishedTasksAggregation(String datesAggName, String instancesAggName) {
        Aggregation dateHistogram = new Aggregation.Builder().dateHistogram(d -> d.field("completionTime").calendarInterval(this.calendarIntervalByAlias(this.tasklistProperties.getArchiver().getRolloverInterval())).format(this.tasklistProperties.getArchiver().getElsRolloverDateFormat()).keyed(Boolean.valueOf(true))).aggregations("datesSortedAgg", new Aggregation.Builder().bucketSort(bs -> bs.sort(s -> s.field(FieldSort.of(f -> f.field("_key").order(SortOrder.Desc)))).size(Integer.valueOf(1))).build()).aggregations(instancesAggName, new Aggregation.Builder().topHits(th -> th.size(Integer.valueOf(this.tasklistProperties.getArchiver().getRolloverBatchSize())).sort(s -> s.field(f -> f.field("id").order(SortOrder.Asc))).source(s -> s.filter(sf -> sf.includes(List.of("id"))))).build()).build();
        return dateHistogram;
    }

    protected AbstractArchiverJob.ArchiveBatch createArchiveBatch(SearchResponse searchResponse) {
        Aggregate agg = (Aggregate)searchResponse.aggregations().get(DATES_AGG);
        DateHistogramAggregate histogramAgg = (DateHistogramAggregate)agg._get();
        Buckets buckets = histogramAgg.buckets();
        HashMap bucket = (HashMap)buckets._get();
        if (bucket.size() > 0) {
            Set bucketEntrySet = bucket.entrySet();
            Iterator iterator = bucketEntrySet.iterator();
            if (iterator.hasNext()) {
                Map.Entry bucketItem = iterator.next();
                String finishDate = (String)bucketItem.getKey();
                HitsMetadata hits = ((Aggregate)((DateHistogramBucket)bucketItem.getValue()).aggregations().get(INSTANCES_AGG)).topHits().hits();
                List<String> ids = hits.hits().stream().map(hit -> ((Hit)hit).id()).collect(Collectors.toList());
                return new AbstractArchiverJob.ArchiveBatch(finishDate, ids);
            }
            return null;
        }
        return null;
    }

    private Timer getArchiverQueryTimer() {
        return this.metrics.getTimer("tasklist.archiver.query", new String[0]);
    }
}

