/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.archiver.es;

import io.camunda.tasklist.archiver.AbstractArchiverJob;
import io.camunda.tasklist.util.ElasticsearchUtil;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class AbstractArchiverJobElasticSearch
extends AbstractArchiverJob {
    @Autowired
    @Qualifier(value="tasklistEsClient")
    private RestHighLevelClient esClient;

    public AbstractArchiverJobElasticSearch(List<Integer> partitionIds) {
        super(partitionIds);
    }

    protected CompletableFuture<SearchResponse> sendSearchRequest(SearchRequest searchRequest) {
        return ElasticsearchUtil.searchAsync((SearchRequest)searchRequest, (Executor)this.archiverExecutor, (RestHighLevelClient)this.esClient);
    }
}

