/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.archiver;

import io.camunda.tasklist.archiver.ArchiverUtil;
import io.camunda.tasklist.property.TasklistProperties;
import io.camunda.tasklist.util.BackoffIdleStrategy;
import jakarta.annotation.PreDestroy;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public abstract class AbstractArchiverJob
implements Runnable {
    protected static final String NOTHING_TO_ARCHIVE = "NothingToArchive";
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractArchiverJob.class);
    @Autowired
    @Qualifier(value="tasklistArchiverThreadPoolExecutor")
    protected ThreadPoolTaskScheduler archiverExecutor;
    @Autowired
    protected ArchiverUtil archiverUtil;
    private final BackoffIdleStrategy idleStrategy;
    private final BackoffIdleStrategy errorStrategy;
    private boolean shutdown = false;
    private final List<Integer> partitionIds;
    @Autowired
    private TasklistProperties tasklistProperties;

    public AbstractArchiverJob(List<Integer> partitionIds) {
        this.partitionIds = partitionIds;
        this.idleStrategy = new BackoffIdleStrategy(2000L, 1.2f, 60000L);
        this.errorStrategy = new BackoffIdleStrategy(100L, 1.2f, 10000L);
    }

    protected abstract CompletableFuture<Map.Entry<String, Integer>> archiveBatch(ArchiveBatch var1);

    protected abstract CompletableFuture<ArchiveBatch> getNextBatch();

    @Override
    public void run() {
        ((CompletableFuture)((CompletableFuture)this.archiveNextBatch().thenApply(map -> {
            this.errorStrategy.reset();
            if ((Integer)map.getValue() >= this.tasklistProperties.getArchiver().getRolloverBatchSize()) {
                this.idleStrategy.reset();
            } else {
                this.idleStrategy.idle();
            }
            long delay = Math.max((long)this.tasklistProperties.getArchiver().getDelayBetweenRuns(), this.idleStrategy.idleTime());
            return delay;
        })).exceptionally(t -> {
            LOGGER.error("Error occurred while archiving data. Will be retried.", t);
            this.errorStrategy.idle();
            return this.errorStrategy.idleTime();
        })).thenAccept(delay -> {
            if (!this.shutdown) {
                this.archiverExecutor.schedule((Runnable)this, Date.from(Instant.now().plusMillis((long)delay)));
            }
        });
    }

    public CompletableFuture<Map.Entry<String, Integer>> archiveNextBatch() {
        return this.getNextBatch().thenCompose(this::archiveBatch);
    }

    public List<Integer> getPartitionIds() {
        return this.partitionIds;
    }

    @PreDestroy
    public void shutdown() {
        this.shutdown = true;
    }

    public static class ArchiveBatch {
        private String finishDate;
        private List<String> ids;

        public ArchiveBatch(List<String> ids) {
            this.ids = ids;
        }

        public ArchiveBatch(String finishDate, List<String> ids) {
            this.finishDate = finishDate;
            this.ids = ids;
        }

        public String getFinishDate() {
            return this.finishDate;
        }

        public void setFinishDate(String finishDate) {
            this.finishDate = finishDate;
        }

        public List<String> getIds() {
            return this.ids;
        }

        public void setIds(List<String> ids) {
            this.ids = ids;
        }

        public String toString() {
            return "AbstractArchiverJob{finishDate='" + this.finishDate + "', ids=" + String.valueOf(this.ids) + "}";
        }
    }
}

