/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.archiver;

import io.camunda.tasklist.archiver.ProcessInstanceArchiverJob;
import io.camunda.tasklist.archiver.TaskArchiverJob;
import io.camunda.tasklist.property.TasklistProperties;
import io.camunda.tasklist.util.CollectionUtil;
import io.camunda.tasklist.zeebe.PartitionHolder;
import jakarta.annotation.PostConstruct;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.DependsOn;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.stereotype.Component;

@Component
@DependsOn(value={"tasklistSchemaStartup"})
public class ArchiverStarter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArchiverStarter.class);
    @Autowired
    @Qualifier(value="tasklistArchiverThreadPoolExecutor")
    public ThreadPoolTaskScheduler taskScheduler;
    @Autowired
    private BeanFactory beanFactory;
    @Autowired
    private TasklistProperties tasklistProperties;
    @Autowired
    private PartitionHolder partitionHolder;

    @PostConstruct
    public void startArchiving() {
        if (this.tasklistProperties.getArchiver().isRolloverEnabled()) {
            LOGGER.info("INIT: Start archiving data...");
            List partitionIds = this.partitionHolder.getPartitionIds();
            LOGGER.info("Starting archiver for partitions: {}", (Object)partitionIds);
            int threadsCount = this.tasklistProperties.getArchiver().getThreadsCount();
            if (threadsCount > partitionIds.size()) {
                LOGGER.warn("Too many archiver threads are configured, not all of them will be in use. Number of threads: {}, number of partitions to parallelize by: {}", (Object)threadsCount, (Object)partitionIds.size());
            }
            for (int i = 0; i < threadsCount; ++i) {
                List partitionIdsSubset = CollectionUtil.splitAndGetSublist((List)partitionIds, (int)threadsCount, (int)i);
                if (partitionIdsSubset.isEmpty()) continue;
                TaskArchiverJob batchOperationArchiverJob = (TaskArchiverJob)this.beanFactory.getBean(TaskArchiverJob.class, new Object[]{partitionIdsSubset});
                this.taskScheduler.execute((Runnable)batchOperationArchiverJob);
                ProcessInstanceArchiverJob processInstanceArchiverJob = (ProcessInstanceArchiverJob)this.beanFactory.getBean(ProcessInstanceArchiverJob.class, new Object[]{partitionIdsSubset});
                this.taskScheduler.execute((Runnable)processInstanceArchiverJob);
            }
        }
    }
}

