package io.camunda.zeebe.spring.test.configuration;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.impl.ZeebeObjectMapper;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;

import static io.camunda.zeebe.spring.client.AbstractZeebeBaseConfiguration.DEFAULT_OBJECT_MAPPER;

/**
 * Fallback values if certain beans are missing
 */
public class ZeebeTestDefaultConfiguration {

  @Bean(name = "zeebeJsonMapper")
  @ConditionalOnMissingBean
  public JsonMapper jsonMapper(ObjectMapper objectMapper) {
    return new ZeebeObjectMapper(objectMapper);
  }

  @Bean
  @ConditionalOnMissingBean
  public ObjectMapper objectMapper() {
    return DEFAULT_OBJECT_MAPPER;
  }

}
