/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.example;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.CamundaOperateClient;
import io.camunda.operate.CamundaOperateClientConfiguration;
import io.camunda.operate.auth.Authentication;
import io.camunda.operate.auth.JwtAuthentication;
import io.camunda.operate.auth.JwtCredential;
import io.camunda.operate.auth.SimpleAuthentication;
import io.camunda.operate.auth.SimpleCredential;
import io.camunda.operate.auth.TokenResponseMapper;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.time.Duration;
import org.apache.hc.client5.http.impl.classic.HttpClients;

public interface OperateClientBootstrapper {
    public CamundaOperateClient createOperateClient() throws MalformedURLException;

    public static class SaasClientBootstrapper
    implements OperateClientBootstrapper {
        @Override
        public CamundaOperateClient createOperateClient() throws MalformedURLException {
            String region = "";
            String clusterId = "";
            String clientId = "";
            String clientSecret = "";
            URL operateUrl = URI.create("https://" + region + ".operate.camunda.io/" + clusterId).toURL();
            URL authUrl = URI.create("https://login.cloud.camunda.io/oauth/token").toURL();
            JwtCredential credentials = new JwtCredential(clientId, clientSecret, "operate.camunda.io", authUrl, null);
            ObjectMapper objectMapper = new ObjectMapper();
            TokenResponseMapper.JacksonTokenResponseMapper tokenResponseMapper = new TokenResponseMapper.JacksonTokenResponseMapper(objectMapper);
            JwtAuthentication authentication = new JwtAuthentication(credentials, (TokenResponseMapper)tokenResponseMapper);
            CamundaOperateClientConfiguration configuration = new CamundaOperateClientConfiguration((Authentication)authentication, operateUrl, objectMapper, HttpClients.createDefault());
            CamundaOperateClient client = new CamundaOperateClient(configuration);
            return client;
        }
    }

    public static class IdentityAuthOperateClientBootstrapper
    implements OperateClientBootstrapper {
        @Override
        public CamundaOperateClient createOperateClient() throws MalformedURLException {
            String clientId = "";
            String clientSecret = "";
            String audience = "operate-api";
            String scope = "";
            URL operateUrl = URI.create("http://localhost:8081").toURL();
            URL authUrl = URI.create("http://localhost:18080/auth/realms/camunda-platform/protocol/openid-connect/token").toURL();
            JwtCredential credentials = new JwtCredential(clientId, clientSecret, audience, authUrl, scope);
            ObjectMapper objectMapper = new ObjectMapper();
            TokenResponseMapper.JacksonTokenResponseMapper tokenResponseMapper = new TokenResponseMapper.JacksonTokenResponseMapper(objectMapper);
            JwtAuthentication authentication = new JwtAuthentication(credentials, (TokenResponseMapper)tokenResponseMapper);
            CamundaOperateClientConfiguration configuration = new CamundaOperateClientConfiguration((Authentication)authentication, operateUrl, objectMapper, HttpClients.createDefault());
            CamundaOperateClient client = new CamundaOperateClient(configuration);
            return client;
        }
    }

    public static class SimpleAuthOperateClientBootstrapper
    implements OperateClientBootstrapper {
        @Override
        public CamundaOperateClient createOperateClient() throws MalformedURLException {
            String username = "demo";
            String password = "demo";
            URL operateUrl = URI.create("http://localhost:8081").toURL();
            SimpleCredential credentials = new SimpleCredential(username, password, operateUrl, Duration.ofMinutes(10L));
            SimpleAuthentication authentication = new SimpleAuthentication(credentials);
            ObjectMapper objectMapper = new ObjectMapper();
            CamundaOperateClientConfiguration configuration = new CamundaOperateClientConfiguration((Authentication)authentication, operateUrl, objectMapper, HttpClients.createDefault());
            CamundaOperateClient client = new CamundaOperateClient(configuration);
            return client;
        }
    }
}

