/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.common.auth;

import io.camunda.common.auth.Authentication;
import io.camunda.common.auth.JwtConfig;
import io.camunda.common.auth.JwtCredential;
import io.camunda.common.auth.Product;
import io.camunda.common.json.JsonMapper;
import io.camunda.operate.auth.JwtAuthentication;
import io.camunda.operate.auth.TokenResponse;
import java.net.MalformedURLException;
import java.net.URI;
import java.time.LocalDateTime;
import java.util.Map;

@Deprecated
public class SaaSAuthentication
implements Authentication {
    private final JwtAuthentication authentication;
    private TokenContext tokenContext;

    public SaaSAuthentication(JwtAuthentication authentication) {
        this.authentication = authentication;
    }

    public SaaSAuthentication(JwtConfig jwtConfig, JsonMapper jsonMapper) {
        this(SaaSAuthentication.jwtAuthentication(jwtConfig, jsonMapper));
    }

    private static JwtAuthentication jwtAuthentication(JwtConfig jwtConfig, JsonMapper jsonMapper) {
        io.camunda.operate.auth.JwtCredential credential;
        JwtCredential jwtCredential = jwtConfig.getJwtCredential();
        try {
            credential = new io.camunda.operate.auth.JwtCredential(jwtCredential.getClientId(), jwtCredential.getClientSecret(), jwtCredential.getAudience(), URI.create(jwtCredential.getAuthUrl()).toURL(), null);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Error while mapping jwt credential", e);
        }
        return new JwtAuthentication(credential, token -> (TokenResponse)jsonMapper.fromJson(token, TokenResponse.class));
    }

    private JwtConfig jwtConfig() {
        JwtConfig jwtConfig = new JwtConfig();
        io.camunda.operate.auth.JwtCredential jwtCredential = this.authentication.getJwtCredential();
        JwtCredential credential = new JwtCredential(jwtCredential.clientId(), jwtCredential.clientSecret(), jwtCredential.audience(), jwtCredential.authUrl().toString());
        jwtConfig.addProduct(Product.ZEEBE, credential);
        return jwtConfig;
    }

    @Override
    public Map<String, String> getTokenHeader(Product product) {
        return this.authentication.getTokenHeader();
    }

    @Override
    public void resetToken(Product product) {
        this.tokenContext = null;
    }

    public JwtConfig getJwtConfig() {
        return this.jwtConfig();
    }

    public JwtAuthentication getJwtAuthentication() {
        return this.authentication;
    }

    private record TokenContext(String token, LocalDateTime expiryDate) {
    }
}

