/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.test;

import io.camunda.client.CamundaClient;
import io.camunda.client.CamundaClientBuilder;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.spring.event.CamundaClientClosingSpringEvent;
import io.camunda.client.spring.event.CamundaClientCreatedSpringEvent;
import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.ZeebeClientBuilder;
import io.camunda.zeebe.process.test.api.RecordStreamSource;
import io.camunda.zeebe.process.test.api.ZeebeTestEngine;
import io.camunda.zeebe.process.test.assertions.BpmnAssert;
import io.camunda.zeebe.process.test.filters.RecordStream;
import io.camunda.zeebe.spring.client.event.ZeebeClientClosingEvent;
import io.camunda.zeebe.spring.client.event.ZeebeClientCreatedEvent;
import io.camunda.zeebe.spring.test.ZeebeTestThreadSupport;
import io.camunda.zeebe.spring.test.proxy.CamundaClientProxy;
import io.camunda.zeebe.spring.test.proxy.ZeebeClientProxy;
import io.camunda.zeebe.spring.test.proxy.ZeebeTestEngineProxy;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.test.context.TestContext;

public class AbstractZeebeTestExecutionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private ZeebeClient zeebeClient;
    private CamundaClient camundaClient;

    public void setupWithZeebeEngine(TestContext testContext, ZeebeTestEngine zeebeEngine) {
        ((ZeebeTestEngineProxy)testContext.getApplicationContext().getBean(ZeebeTestEngineProxy.class)).swapZeebeEngine(zeebeEngine);
        BpmnAssert.initRecordStream((RecordStream)RecordStream.of((RecordStreamSource)zeebeEngine.getRecordStreamSource()));
        ZeebeTestThreadSupport.setEngineForCurrentThread(zeebeEngine);
        LOGGER.info("Test engine setup. Now starting deployments and workers...");
        this.zeebeClient = this.createZeebeClient(testContext, zeebeEngine);
        ((ZeebeClientProxy)testContext.getApplicationContext().getBean(ZeebeClientProxy.class)).swapZeebeClient(this.zeebeClient);
        testContext.getApplicationContext().publishEvent((ApplicationEvent)new ZeebeClientCreatedEvent((Object)this, this.zeebeClient));
        this.camundaClient = this.createCamundaClient(testContext, zeebeEngine);
        ((CamundaClientProxy)testContext.getApplicationContext().getBean(CamundaClientProxy.class)).swapZeebeClient(this.camundaClient);
        testContext.getApplicationContext().publishEvent((ApplicationEvent)new CamundaClientCreatedSpringEvent(this, this.camundaClient){});
        LOGGER.info("...deployments and workers started.");
    }

    public ZeebeClient createZeebeClient(TestContext testContext, ZeebeTestEngine zeebeEngine) {
        ZeebeClientBuilder builder = ZeebeClient.newClientBuilder().preferRestOverGrpc(false).gatewayAddress(zeebeEngine.getGatewayAddress()).usePlaintext();
        if (testContext.getApplicationContext().getBeanNamesForType(io.camunda.zeebe.client.api.JsonMapper.class).length > 0) {
            io.camunda.zeebe.client.api.JsonMapper jsonMapper = (io.camunda.zeebe.client.api.JsonMapper)testContext.getApplicationContext().getBean(io.camunda.zeebe.client.api.JsonMapper.class);
            builder.withJsonMapper(jsonMapper);
        }
        builder.applyEnvironmentVariableOverrides(false);
        return builder.build();
    }

    public CamundaClient createCamundaClient(TestContext testContext, ZeebeTestEngine zeebeEngine) {
        CamundaClientBuilder builder = CamundaClient.newClientBuilder().preferRestOverGrpc(false).grpcAddress(URI.create("http://" + zeebeEngine.getGatewayAddress()));
        if (testContext.getApplicationContext().getBeanNamesForType(JsonMapper.class).length > 0) {
            JsonMapper jsonMapper = (JsonMapper)testContext.getApplicationContext().getBean(JsonMapper.class);
            builder.withJsonMapper(jsonMapper);
        }
        builder.applyEnvironmentVariableOverrides(false);
        return builder.build();
    }

    public void cleanup(TestContext testContext, ZeebeTestEngine zeebeEngine) {
        if (testContext.getTestException() != null) {
            LOGGER.warn("Test failure on '" + String.valueOf(testContext.getTestMethod()) + "'. Tracing workflow engine internals on INFO for debugging purposes:");
            RecordStream recordStream = RecordStream.of((RecordStreamSource)zeebeEngine.getRecordStreamSource());
            recordStream.print(true);
            if (recordStream.incidentRecords().iterator().hasNext()) {
                LOGGER.warn("There were incidents in Zeebe during '" + String.valueOf(testContext.getTestMethod()) + "', maybe they caused some unexpected behavior for you? Please check below:");
                recordStream.incidentRecords().forEach(record -> LOGGER.warn(". " + String.valueOf(record.getValue())));
            }
        }
        BpmnAssert.resetRecordStream();
        ZeebeTestThreadSupport.cleanupEngineForCurrentThread();
        testContext.getApplicationContext().publishEvent((ApplicationEvent)new ZeebeClientClosingEvent((Object)this, this.zeebeClient));
        ((ZeebeClientProxy)testContext.getApplicationContext().getBean(ZeebeClientProxy.class)).removeZeebeClient();
        this.zeebeClient.close();
        testContext.getApplicationContext().publishEvent((ApplicationEvent)new CamundaClientClosingSpringEvent((Object)this, this.camundaClient));
        ((CamundaClientProxy)testContext.getApplicationContext().getBean(CamundaClientProxy.class)).removeCamundaClient();
        this.camundaClient.close();
        ((ZeebeTestEngineProxy)testContext.getApplicationContext().getBean(ZeebeTestEngineProxy.class)).removeZeebeEngine();
    }
}

