/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.spring.client.properties;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.camunda.client.api.response.ActivatedJob;
import io.camunda.spring.client.annotation.AnnotationUtil;
import io.camunda.spring.client.annotation.customizer.JobWorkerValueCustomizer;
import io.camunda.spring.client.annotation.value.JobWorkerValue;
import io.camunda.spring.client.bean.CopyNotNullBeanUtilsBean;
import io.camunda.spring.client.bean.MethodInfo;
import io.camunda.spring.client.bean.ParameterInfo;
import io.camunda.spring.client.properties.CamundaClientProperties;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class PropertyBasedJobWorkerValueCustomizer
implements JobWorkerValueCustomizer {
    private static final Logger LOG = LoggerFactory.getLogger(PropertyBasedJobWorkerValueCustomizer.class);
    private static final CopyNotNullBeanUtilsBean BEAN_UTILS_BEAN = new CopyNotNullBeanUtilsBean();
    private final CamundaClientProperties camundaClientProperties;

    public PropertyBasedJobWorkerValueCustomizer(CamundaClientProperties camundaClientProperties) {
        this.camundaClientProperties = camundaClientProperties;
    }

    @Override
    public void customize(JobWorkerValue jobWorkerValue) {
        this.applyDefaultWorkerName(jobWorkerValue);
        this.applyDefaultJobWorkerType(jobWorkerValue);
        this.applyDefaultJobWorkerTenantIds(jobWorkerValue);
        this.applyFetchVariables(jobWorkerValue);
        this.applyOverrides(jobWorkerValue);
    }

    private void applyFetchVariables(JobWorkerValue jobWorkerValue) {
        if (this.hasActivatedJobInjected(jobWorkerValue)) {
            LOG.debug("Worker '{}': ActivatedJob is injected, no variable filtering possible", (Object)jobWorkerValue.getName());
        } else if (jobWorkerValue.getForceFetchAllVariables() != null && jobWorkerValue.getForceFetchAllVariables().booleanValue()) {
            LOG.debug("Worker '{}': Force fetch all variables is enabled", (Object)jobWorkerValue.getName());
            jobWorkerValue.setFetchVariables(List.of());
        } else {
            HashSet<String> variables = new HashSet<String>();
            if (jobWorkerValue.getFetchVariables() != null) {
                variables.addAll(jobWorkerValue.getFetchVariables());
            }
            variables.addAll(this.readZeebeVariableParameters(jobWorkerValue.getMethodInfo()).stream().map(this::extractVariableName).toList());
            variables.addAll(this.readVariablesAsTypeParameters(jobWorkerValue.getMethodInfo()));
            jobWorkerValue.setFetchVariables(variables.stream().toList());
            LOG.debug("Worker '{}': Fetching only required variables {}", (Object)jobWorkerValue.getName(), variables);
        }
    }

    private boolean hasActivatedJobInjected(JobWorkerValue jobWorkerValue) {
        return jobWorkerValue.getMethodInfo().getParameters().stream().anyMatch(p -> p.getParameterInfo().getType().isAssignableFrom(ActivatedJob.class));
    }

    private List<ParameterInfo> readZeebeVariableParameters(MethodInfo methodInfo) {
        return AnnotationUtil.getVariableParameters(methodInfo);
    }

    private String extractVariableName(ParameterInfo parameterInfo) {
        return AnnotationUtil.getVariableValue(parameterInfo).get().getName();
    }

    private List<String> readVariablesAsTypeParameters(MethodInfo methodInfo) {
        ArrayList<String> result = new ArrayList<String>();
        List<ParameterInfo> parameters = AnnotationUtil.getVariablesAsTypeParameters(methodInfo);
        parameters.forEach(pi -> ReflectionUtils.doWithFields(pi.getParameterInfo().getType(), f -> result.add(this.extractFieldName(f))));
        return result;
    }

    private String extractFieldName(Field field) {
        String value;
        if (field.isAnnotationPresent(JsonProperty.class) && StringUtils.isNotBlank((CharSequence)(value = field.getAnnotation(JsonProperty.class).value()))) {
            return value;
        }
        return field.getName();
    }

    private void applyOverrides(JobWorkerValue zeebeWorker) {
        String workerType;
        JobWorkerValue defaults = this.camundaClientProperties.getWorker().getDefaults();
        try {
            if (defaults != null) {
                BEAN_UTILS_BEAN.copyProperties(zeebeWorker, defaults);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Error while copying properties from " + String.valueOf(defaults) + " to " + String.valueOf(zeebeWorker), e);
        }
        HashMap<String, JobWorkerValue> workerConfigurationMap = new HashMap<String, JobWorkerValue>();
        if (this.camundaClientProperties.getWorker().getOverride() != null) {
            workerConfigurationMap.putAll(this.camundaClientProperties.getWorker().getOverride());
        }
        if (workerConfigurationMap.containsKey(workerType = zeebeWorker.getType())) {
            JobWorkerValue jobWorkerValue = (JobWorkerValue)workerConfigurationMap.get(workerType);
            LOG.debug("Worker '{}': Applying overrides {}", (Object)workerType, (Object)jobWorkerValue);
            try {
                BEAN_UTILS_BEAN.copyProperties(zeebeWorker, jobWorkerValue);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException("Error while copying properties from " + String.valueOf(jobWorkerValue) + " to " + String.valueOf(zeebeWorker), e);
            }
        }
    }

    private void applyDefaultWorkerName(JobWorkerValue zeebeWorker) {
        String defaultJobWorkerName = this.camundaClientProperties.getWorker().getDefaults().getName();
        if (StringUtils.isBlank((CharSequence)zeebeWorker.getName())) {
            if (StringUtils.isNotBlank((CharSequence)defaultJobWorkerName)) {
                LOG.debug("Worker '{}': Setting name to default {}", (Object)zeebeWorker.getName(), (Object)defaultJobWorkerName);
                zeebeWorker.setName(defaultJobWorkerName);
            } else {
                String generatedJobWorkerName = zeebeWorker.getMethodInfo().getBeanName() + "#" + zeebeWorker.getMethodInfo().getMethodName();
                LOG.debug("Worker '{}': Setting name to generated {}", (Object)zeebeWorker.getName(), (Object)generatedJobWorkerName);
                zeebeWorker.setName(generatedJobWorkerName);
            }
        }
    }

    private void applyDefaultJobWorkerType(JobWorkerValue zeebeWorker) {
        String defaultJobWorkerType = this.camundaClientProperties.getWorker().getDefaults().getType();
        if (StringUtils.isBlank((CharSequence)zeebeWorker.getType())) {
            if (StringUtils.isNotBlank((CharSequence)defaultJobWorkerType)) {
                LOG.debug("Worker '{}': Setting type to default {}", (Object)zeebeWorker.getName(), (Object)defaultJobWorkerType);
                zeebeWorker.setType(defaultJobWorkerType);
            } else {
                String generatedJobWorkerType = zeebeWorker.getMethodInfo().getMethodName();
                LOG.debug("Worker '{}': Setting type to generated {}", (Object)zeebeWorker.getName(), (Object)generatedJobWorkerType);
                zeebeWorker.setType(generatedJobWorkerType);
            }
        }
    }

    private void applyDefaultJobWorkerTenantIds(JobWorkerValue zeebeWorker) {
        HashSet defaultJobWorkerTenantIds = new HashSet(Optional.ofNullable(this.camundaClientProperties.getWorker().getDefaults().getTenantIds()).orElse(Collections.emptyList()));
        if ((zeebeWorker.getTenantIds() == null || zeebeWorker.getTenantIds().isEmpty()) && !defaultJobWorkerTenantIds.isEmpty()) {
            LOG.debug("Worker '{}': Setting tenantIds to default {}", zeebeWorker.getTenantIds(), defaultJobWorkerTenantIds);
            zeebeWorker.setTenantIds(new ArrayList<String>(defaultJobWorkerTenantIds));
        }
    }
}

