/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.spring.client.properties;

import io.camunda.spring.client.properties.CamundaClientLegacyPropertiesMapping;
import io.camunda.spring.client.properties.CamundaClientLegacyPropertiesMappingsLoader;
import io.camunda.spring.client.properties.CamundaClientProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.env.YamlPropertySourceLoader;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class CamundaClientPropertiesPostProcessor
implements EnvironmentPostProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(CamundaClientPropertiesPostProcessor.class);
    private static final String OVERRIDE_PREFIX = "camunda.client.worker.override.";
    private static final List<String> LEGACY_OVERRIDE_PREFIX = List.of("camunda.client.zeebe.override.", "zeebe.client.worker.override.");

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        this.mapLegacyProperties(environment);
        this.mapLegacyOverrides(environment);
        this.processClientMode(environment);
    }

    private void mapLegacyOverrides(ConfigurableEnvironment environment) {
        HashMap properties = new HashMap();
        environment.getPropertySources().stream().filter(o -> EnumerablePropertySource.class.isAssignableFrom(o.getClass())).map(EnumerablePropertySource.class::cast).forEach(propertySource -> {
            for (String propertyName : propertySource.getPropertyNames()) {
                for (String prefix : LEGACY_OVERRIDE_PREFIX) {
                    String newPropertyName;
                    String normalizedPropertyName = propertyName.replaceAll("_", ".").toLowerCase();
                    if (!normalizedPropertyName.startsWith(prefix) || properties.containsKey(newPropertyName = OVERRIDE_PREFIX + normalizedPropertyName.substring(prefix.length())) || environment.containsProperty(newPropertyName)) continue;
                    LOG.debug("Mapping worker override from '{}' to '{}'", (Object)propertyName, (Object)newPropertyName);
                    properties.put(newPropertyName, propertySource.getProperty(propertyName));
                }
            }
        });
        MapPropertySource propertySource2 = new MapPropertySource("camunda-client-legacy-worker-overrides.properties", properties);
        environment.getPropertySources().addFirst((PropertySource)propertySource2);
    }

    private void mapLegacyProperties(ConfigurableEnvironment environment) {
        HashMap properties = new HashMap();
        List<CamundaClientLegacyPropertiesMapping> mappings = CamundaClientLegacyPropertiesMappingsLoader.load();
        mappings.forEach(mapping -> this.detectPropertyValue(environment, (CamundaClientLegacyPropertiesMapping)mapping).forEach(detectedPropertyValue -> properties.put(mapping.getPropertyName(), detectedPropertyValue)));
        MapPropertySource propertySource = new MapPropertySource("camunda-client-legacy-overrides.properties", properties);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
    }

    private List<String> detectPropertyValue(ConfigurableEnvironment environment, CamundaClientLegacyPropertiesMapping property) {
        if (environment.containsProperty(property.getPropertyName())) {
            LOG.debug("Property '{}' found, not looking up legacy properties", (Object)property.getPropertyName());
            return List.of(Objects.requireNonNull(environment.getProperty(property.getPropertyName())));
        }
        for (String legacyPropertyName : property.getLegacyPropertyNames()) {
            if (!environment.containsProperty(legacyPropertyName)) continue;
            LOG.warn("Legacy property '{}' found, setting to '{}'. Please update your setup to use the latest property", (Object)legacyPropertyName, (Object)property.getPropertyName());
            return List.of(Objects.requireNonNull(environment.getProperty(legacyPropertyName)));
        }
        LOG.debug("No property found for '{}'", (Object)property.getPropertyName());
        return List.of();
    }

    private void processClientMode(ConfigurableEnvironment environment) {
        try {
            CamundaClientProperties.ClientMode clientMode = (CamundaClientProperties.ClientMode)((Object)environment.getProperty("camunda.client.mode", CamundaClientProperties.ClientMode.class));
            if (clientMode == null) {
                if (this.isImplicitSaas(environment)) {
                    clientMode = CamundaClientProperties.ClientMode.saas;
                } else {
                    return;
                }
            }
            YamlPropertySourceLoader loader = new YamlPropertySourceLoader();
            String propertiesFile = this.determinePropertiesFile(clientMode);
            ClassPathResource resource = new ClassPathResource(propertiesFile);
            List props = loader.load(propertiesFile, (Resource)resource);
            for (PropertySource prop : props) {
                environment.getPropertySources().addLast(prop);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Error while post processing camunda properties", e);
        }
    }

    private boolean isImplicitSaas(ConfigurableEnvironment environment) {
        if (environment.containsProperty("camunda.client.cloud.cluster-id")) {
            LOG.debug("Cluster id detected, setting implicit saas mode");
            return true;
        }
        return false;
    }

    private String determinePropertiesFile(CamundaClientProperties.ClientMode clientMode) {
        switch (clientMode) {
            case selfManaged: {
                return "modes/self-managed.yaml";
            }
            case saas: {
                return "modes/saas.yaml";
            }
            case basic: {
                return "modes/basic.yaml";
            }
        }
        throw new IllegalStateException("Unknown client mode " + String.valueOf((Object)clientMode));
    }
}

