/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.spring.client.jobhandling;

import io.camunda.client.api.command.CompleteJobCommandStep1;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.command.ThrowErrorCommandStep1;
import io.camunda.client.api.response.ActivatedJob;
import io.camunda.client.api.response.CompleteJobResponse;
import io.camunda.client.api.worker.JobClient;
import io.camunda.client.api.worker.JobHandler;
import io.camunda.client.impl.Loggers;
import io.camunda.spring.client.annotation.value.JobWorkerValue;
import io.camunda.spring.client.exception.CamundaBpmnError;
import io.camunda.spring.client.jobhandling.CommandExceptionHandlingStrategy;
import io.camunda.spring.client.jobhandling.CommandWrapper;
import io.camunda.spring.client.jobhandling.parameter.ParameterResolver;
import io.camunda.spring.client.jobhandling.parameter.ParameterResolverStrategy;
import io.camunda.spring.client.jobhandling.result.ResultProcessor;
import io.camunda.spring.client.jobhandling.result.ResultProcessorStrategy;
import io.camunda.spring.client.metrics.MetricsRecorder;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class JobHandlerInvokingSpringBeans
implements JobHandler {
    private static final Logger LOG = Loggers.JOB_WORKER_LOGGER;
    private final JobWorkerValue workerValue;
    private final CommandExceptionHandlingStrategy commandExceptionHandlingStrategy;
    private final MetricsRecorder metricsRecorder;
    private final List<ParameterResolver> parameterResolvers;
    private final ResultProcessor resultProcessor;

    public JobHandlerInvokingSpringBeans(JobWorkerValue workerValue, CommandExceptionHandlingStrategy commandExceptionHandlingStrategy, MetricsRecorder metricsRecorder, ParameterResolverStrategy parameterResolverStrategy, ResultProcessorStrategy resultProcessorStrategy) {
        this.workerValue = workerValue;
        this.commandExceptionHandlingStrategy = commandExceptionHandlingStrategy;
        this.metricsRecorder = metricsRecorder;
        this.parameterResolvers = this.createParameterResolvers(parameterResolverStrategy);
        this.resultProcessor = this.createResultProcessor(resultProcessorStrategy);
    }

    private List<ParameterResolver> createParameterResolvers(ParameterResolverStrategy parameterResolverStrategy) {
        return this.workerValue.getMethodInfo().getParameters().stream().map(parameterResolverStrategy::createResolver).toList();
    }

    private ResultProcessor createResultProcessor(ResultProcessorStrategy resultProcessorStrategy) {
        return resultProcessorStrategy.createProcessor(this.workerValue.getMethodInfo().getReturnType());
    }

    public void handle(JobClient jobClient, ActivatedJob job) throws Exception {
        List<Object> args = this.createParameters(jobClient, job);
        LOG.trace("Handle {} and invoke worker {}", (Object)job, (Object)this.workerValue);
        try {
            Object result;
            this.metricsRecorder.increase("camunda.job.invocations", "activated", job.getType());
            try {
                Object methodInvocationResult = this.workerValue.getMethodInfo().invoke(args.toArray());
                result = this.resultProcessor.process(methodInvocationResult);
            }
            catch (Throwable t) {
                this.metricsRecorder.increase("camunda.job.invocations", "failed", job.getType());
                throw t;
            }
            if (this.workerValue.getAutoComplete().booleanValue()) {
                LOG.trace("Auto completing {}", (Object)job);
                CommandWrapper command = new CommandWrapper(this.createCompleteCommand(jobClient, job, result), job, this.commandExceptionHandlingStrategy, this.metricsRecorder, this.workerValue.getMaxRetries());
                command.executeAsyncWithMetrics("camunda.job.invocations", "completed", job.getType());
            }
        }
        catch (CamundaBpmnError bpmnError) {
            LOG.trace("Catched BPMN error on {}", (Object)job);
            CommandWrapper command = new CommandWrapper(this.createThrowErrorCommand(jobClient, job, bpmnError), job, this.commandExceptionHandlingStrategy, this.metricsRecorder, this.workerValue.getMaxRetries());
            command.executeAsyncWithMetrics("camunda.job.invocations", "bpmn-error", job.getType());
        }
    }

    private List<Object> createParameters(JobClient jobClient, ActivatedJob job) {
        return this.parameterResolvers.stream().map(resolver -> resolver.resolve(jobClient, job)).toList();
    }

    private FinalCommandStep<CompleteJobResponse> createCompleteCommand(JobClient jobClient, ActivatedJob job, Object result) {
        CompleteJobCommandStep1 completeCommand = jobClient.newCompleteCommand(job.getKey());
        if (result != null) {
            completeCommand = result.getClass().isAssignableFrom(Map.class) ? completeCommand.variables((Map)result) : (result.getClass().isAssignableFrom(String.class) ? completeCommand.variables((String)result) : (result.getClass().isAssignableFrom(InputStream.class) ? completeCommand.variables((InputStream)result) : completeCommand.variables(result)));
        }
        return completeCommand;
    }

    private FinalCommandStep<Void> createThrowErrorCommand(JobClient jobClient, ActivatedJob job, CamundaBpmnError bpmnError) {
        ThrowErrorCommandStep1.ThrowErrorCommandStep2 command = jobClient.newThrowErrorCommand(job.getKey()).errorCode(bpmnError.getErrorCode()).errorMessage(bpmnError.getErrorMessage());
        if (bpmnError.getVariables() != null) {
            command.variables(bpmnError.getVariables());
        }
        return command;
    }
}

