/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.spring.client.configuration;

import io.camunda.client.CredentialsProvider;
import io.camunda.client.impl.NoopCredentialsProvider;
import io.camunda.client.impl.basicauth.BasicAuthCredentialsProviderBuilder;
import io.camunda.client.impl.oauth.OAuthCredentialsProviderBuilder;
import io.camunda.spring.client.properties.CamundaClientProperties;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CredentialsProviderConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(CredentialsProviderConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public CredentialsProvider camundaClientCredentialsProvider(CamundaClientProperties camundaClientProperties) {
        NoopCredentialsProvider noopCredentialsProvider;
        CamundaClientProperties.ClientMode clientMode = camundaClientProperties.getMode();
        if (clientMode == null) {
            noopCredentialsProvider = new NoopCredentialsProvider();
        } else {
            switch (clientMode) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case basic: {
                    noopCredentialsProvider = this.buildBasicAuthCredentialsProvider(camundaClientProperties);
                    break;
                }
                case saas: 
                case selfManaged: {
                    noopCredentialsProvider = this.buildOAuthCredentialsProvider(camundaClientProperties);
                }
            }
        }
        return noopCredentialsProvider;
    }

    private CredentialsProvider buildBasicAuthCredentialsProvider(CamundaClientProperties camundaClientProperties) {
        String username = camundaClientProperties.getAuth().getUsername();
        String password = camundaClientProperties.getAuth().getPassword();
        BasicAuthCredentialsProviderBuilder builder = new BasicAuthCredentialsProviderBuilder().applyEnvironmentOverrides(false).username(username).password(password);
        try {
            return builder.build();
        }
        catch (Exception e) {
            LOG.warn("Failed to configure credential provider", (Throwable)e);
            return new NoopCredentialsProvider();
        }
    }

    private CredentialsProvider buildOAuthCredentialsProvider(CamundaClientProperties camundaClientProperties) {
        OAuthCredentialsProviderBuilder credBuilder = CredentialsProvider.newCredentialsProviderBuilder().applyEnvironmentOverrides(false).clientId(camundaClientProperties.getAuth().getClientId()).clientSecret(camundaClientProperties.getAuth().getClientSecret()).audience(camundaClientProperties.getAuth().getAudience()).scope(camundaClientProperties.getAuth().getScope()).authorizationServerUrl((String)Optional.ofNullable(camundaClientProperties.getAuth().getTokenUrl()).map(URI::toString).orElse(null)).credentialsCachePath(camundaClientProperties.getAuth().getCredentialsCachePath()).connectTimeout(camundaClientProperties.getAuth().getConnectTimeout()).readTimeout(camundaClientProperties.getAuth().getReadTimeout());
        this.maybeConfigureIdentityProviderSSLConfig(credBuilder, camundaClientProperties);
        try {
            return credBuilder.build();
        }
        catch (Exception e) {
            LOG.warn("Failed to configure credential provider", (Throwable)e);
            return new NoopCredentialsProvider();
        }
    }

    private void maybeConfigureIdentityProviderSSLConfig(OAuthCredentialsProviderBuilder builder, CamundaClientProperties camundaClientProperties) {
        if (camundaClientProperties.getAuth() == null) {
            return;
        }
        if (camundaClientProperties.getAuth().getKeystorePath() != null) {
            Path keyStore = Paths.get(camundaClientProperties.getAuth().getKeystorePath(), new String[0]);
            if (Files.exists(keyStore, new LinkOption[0])) {
                LOG.debug("Using keystore {}", (Object)keyStore);
                builder.keystorePath(keyStore);
                builder.keystorePassword(camundaClientProperties.getAuth().getKeystorePassword());
                builder.keystoreKeyPassword(camundaClientProperties.getAuth().getKeystoreKeyPassword());
            } else {
                LOG.debug("Keystore {} not found", (Object)keyStore);
            }
        }
        if (camundaClientProperties.getAuth().getTruststorePath() != null) {
            Path trustStore = Paths.get(camundaClientProperties.getAuth().getTruststorePath(), new String[0]);
            if (Files.exists(trustStore, new LinkOption[0])) {
                LOG.debug("Using truststore {}", (Object)trustStore);
                builder.truststorePath(trustStore);
                builder.truststorePassword(camundaClientProperties.getAuth().getTruststorePassword());
            } else {
                LOG.debug("Truststore {} not found", (Object)trustStore);
            }
        }
    }
}

