/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.spring.client.configuration;

import io.camunda.client.CamundaClient;
import io.camunda.client.CamundaClientConfiguration;
import io.camunda.client.CredentialsProvider;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.impl.CamundaClientImpl;
import io.camunda.client.impl.util.ExecutorResource;
import io.camunda.spring.client.configuration.CamundaActuatorConfiguration;
import io.camunda.spring.client.configuration.CamundaClientAllAutoConfiguration;
import io.camunda.spring.client.configuration.CamundaClientConfigurationImpl;
import io.camunda.spring.client.configuration.CredentialsProviderConfiguration;
import io.camunda.spring.client.configuration.ExecutorServiceConfiguration;
import io.camunda.spring.client.configuration.JsonMapperConfiguration;
import io.camunda.spring.client.jobhandling.CamundaClientExecutorService;
import io.camunda.spring.client.properties.CamundaClientProperties;
import io.camunda.spring.client.testsupport.CamundaSpringProcessTestContext;
import io.camunda.zeebe.gateway.protocol.GatewayGrpc;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.hc.client5.http.async.AsyncExecChainHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;

@ConditionalOnProperty(prefix="camunda.client", name={"enabled"}, havingValue="true", matchIfMissing=true)
@ConditionalOnMissingBean(value={CamundaSpringProcessTestContext.class})
@ImportAutoConfiguration(value={ExecutorServiceConfiguration.class, CamundaActuatorConfiguration.class, JsonMapperConfiguration.class, CredentialsProviderConfiguration.class})
@AutoConfigureBefore(value={CamundaClientAllAutoConfiguration.class})
public class CamundaClientProdAutoConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(CamundaClientProdAutoConfiguration.class);

    @Bean
    public CamundaClientConfiguration camundaClientConfiguration(CamundaClientProperties camundaClientProperties, JsonMapper jsonMapper, List<ClientInterceptor> interceptors, List<AsyncExecChainHandler> chainHandlers, CamundaClientExecutorService camundaClientExecutorService, CredentialsProvider camundaClientCredentialsProvider) {
        return new CamundaClientConfigurationImpl(camundaClientProperties, jsonMapper, interceptors, chainHandlers, camundaClientExecutorService, camundaClientCredentialsProvider){};
    }

    @Bean(destroyMethod="close")
    public CamundaClient camundaClient(CamundaClientConfiguration configuration) {
        LOG.info("Creating camundaClient using CamundaClientConfiguration [{}]", (Object)configuration);
        ScheduledExecutorService jobWorkerExecutor = configuration.jobWorkerExecutor();
        if (jobWorkerExecutor != null) {
            ManagedChannel managedChannel = CamundaClientImpl.buildChannel((CamundaClientConfiguration)configuration);
            GatewayGrpc.GatewayStub gatewayStub = CamundaClientImpl.buildGatewayStub((ManagedChannel)managedChannel, (CamundaClientConfiguration)configuration);
            ExecutorResource executorResource = new ExecutorResource(jobWorkerExecutor, configuration.ownsJobWorkerExecutor());
            return new CamundaClientImpl(configuration, managedChannel, gatewayStub, executorResource);
        }
        return new CamundaClientImpl(configuration);
    }
}

