/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.spring.client.configuration;

import io.camunda.client.CamundaClientConfiguration;
import io.camunda.client.CredentialsProvider;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.impl.CamundaClientBuilderImpl;
import io.camunda.spring.client.jobhandling.CamundaClientExecutorService;
import io.camunda.spring.client.properties.CamundaClientProperties;
import io.grpc.ClientInterceptor;
import java.net.MalformedURLException;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.hc.client5.http.async.AsyncExecChainHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.unit.DataSize;

public class CamundaClientConfigurationImpl
implements CamundaClientConfiguration {
    public static final CamundaClientBuilderImpl DEFAULT = (CamundaClientBuilderImpl)new CamundaClientBuilderImpl().withProperties(new Properties());
    private static final Logger LOG = LoggerFactory.getLogger(CamundaClientConfigurationImpl.class);
    private final CamundaClientProperties camundaClientProperties;
    private final JsonMapper jsonMapper;
    private final List<ClientInterceptor> interceptors;
    private final List<AsyncExecChainHandler> chainHandlers;
    private final CamundaClientExecutorService zeebeClientExecutorService;
    private final CredentialsProvider credentialsProvider;

    public CamundaClientConfigurationImpl(CamundaClientProperties camundaClientProperties, JsonMapper jsonMapper, List<ClientInterceptor> interceptors, List<AsyncExecChainHandler> chainHandlers, CamundaClientExecutorService zeebeClientExecutorService, CredentialsProvider credentialsProvider) {
        this.camundaClientProperties = camundaClientProperties;
        this.jsonMapper = jsonMapper;
        this.interceptors = interceptors;
        this.chainHandlers = chainHandlers;
        this.zeebeClientExecutorService = zeebeClientExecutorService;
        this.credentialsProvider = credentialsProvider;
    }

    private static <T> T propertyOrDefault(T property, T defaultValue) {
        if (property == null) {
            return defaultValue;
        }
        return property;
    }

    public String getGatewayAddress() {
        return CamundaClientConfigurationImpl.propertyOrDefault(this.composeGatewayAddress(), DEFAULT.getGatewayAddress());
    }

    public URI getRestAddress() {
        return CamundaClientConfigurationImpl.propertyOrDefault(this.camundaClientProperties.getRestAddress(), DEFAULT.getRestAddress());
    }

    public URI getGrpcAddress() {
        return CamundaClientConfigurationImpl.propertyOrDefault(this.camundaClientProperties.getGrpcAddress(), DEFAULT.getGrpcAddress());
    }

    public String getDefaultTenantId() {
        return CamundaClientConfigurationImpl.propertyOrDefault(this.camundaClientProperties.getTenantId(), DEFAULT.getDefaultTenantId());
    }

    public List<String> getDefaultJobWorkerTenantIds() {
        return CamundaClientConfigurationImpl.propertyOrDefault(this.camundaClientProperties.getWorker().getDefaults().getTenantIds(), DEFAULT.getDefaultJobWorkerTenantIds());
    }

    public int getNumJobWorkerExecutionThreads() {
        return CamundaClientConfigurationImpl.propertyOrDefault(this.camundaClientProperties.getExecutionThreads(), DEFAULT.getNumJobWorkerExecutionThreads());
    }

    public int getDefaultJobWorkerMaxJobsActive() {
        return CamundaClientConfigurationImpl.propertyOrDefault(this.camundaClientProperties.getWorker().getDefaults().getMaxJobsActive(), DEFAULT.getDefaultJobWorkerMaxJobsActive());
    }

    public String getDefaultJobWorkerName() {
        return CamundaClientConfigurationImpl.propertyOrDefault(this.camundaClientProperties.getWorker().getDefaults().getName(), DEFAULT.getDefaultJobWorkerName());
    }

    public Duration getDefaultJobTimeout() {
        return CamundaClientConfigurationImpl.propertyOrDefault(this.camundaClientProperties.getWorker().getDefaults().getTimeout(), DEFAULT.getDefaultJobTimeout());
    }

    public Duration getDefaultJobPollInterval() {
        return CamundaClientConfigurationImpl.propertyOrDefault(this.camundaClientProperties.getWorker().getDefaults().getPollInterval(), DEFAULT.getDefaultJobPollInterval());
    }

    public Duration getDefaultMessageTimeToLive() {
        return CamundaClientConfigurationImpl.propertyOrDefault(this.camundaClientProperties.getMessageTimeToLive(), DEFAULT.getDefaultMessageTimeToLive());
    }

    public Duration getDefaultRequestTimeout() {
        return CamundaClientConfigurationImpl.propertyOrDefault(this.camundaClientProperties.getRequestTimeout(), DEFAULT.getDefaultRequestTimeout());
    }

    public boolean isPlaintextConnectionEnabled() {
        return CamundaClientConfigurationImpl.propertyOrDefault(this.composePlaintext(), DEFAULT.isPlaintextConnectionEnabled());
    }

    public String getCaCertificatePath() {
        return CamundaClientConfigurationImpl.propertyOrDefault(this.camundaClientProperties.getCaCertificatePath(), DEFAULT.getCaCertificatePath());
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public Duration getKeepAlive() {
        return CamundaClientConfigurationImpl.propertyOrDefault(this.camundaClientProperties.getKeepAlive(), DEFAULT.getKeepAlive());
    }

    public List<ClientInterceptor> getInterceptors() {
        return this.interceptors;
    }

    public List<AsyncExecChainHandler> getChainHandlers() {
        return this.chainHandlers;
    }

    public JsonMapper getJsonMapper() {
        return this.jsonMapper;
    }

    public String getOverrideAuthority() {
        return CamundaClientConfigurationImpl.propertyOrDefault(this.camundaClientProperties.getOverrideAuthority(), DEFAULT.getOverrideAuthority());
    }

    public int getMaxMessageSize() {
        return Optional.ofNullable(this.camundaClientProperties.getMaxMessageSize()).map(DataSize::toBytes).map(Math::toIntExact).orElse(DEFAULT.getMaxMessageSize());
    }

    public int getMaxMetadataSize() {
        return Optional.ofNullable(this.camundaClientProperties.getMaxMetadataSize()).map(DataSize::toBytes).map(Math::toIntExact).orElse(DEFAULT.getMaxMetadataSize());
    }

    public ScheduledExecutorService jobWorkerExecutor() {
        return this.zeebeClientExecutorService.get();
    }

    public boolean ownsJobWorkerExecutor() {
        return this.zeebeClientExecutorService.isOwnedByCamundaClient();
    }

    public boolean getDefaultJobWorkerStreamEnabled() {
        return CamundaClientConfigurationImpl.propertyOrDefault(this.camundaClientProperties.getWorker().getDefaults().getStreamEnabled(), DEFAULT.getDefaultJobWorkerStreamEnabled());
    }

    public boolean useDefaultRetryPolicy() {
        return false;
    }

    public boolean preferRestOverGrpc() {
        return CamundaClientConfigurationImpl.propertyOrDefault(this.camundaClientProperties.getPreferRestOverGrpc(), DEFAULT.preferRestOverGrpc());
    }

    private String composeGatewayAddress() {
        int defaultPort;
        URI gatewayUrl = this.getGrpcAddress();
        int port = gatewayUrl.getPort();
        String host = gatewayUrl.getHost();
        if (port != -1) {
            return this.composeAddressWithPort(host, port, "Gateway port is set");
        }
        try {
            defaultPort = gatewayUrl.toURL().getDefaultPort();
        }
        catch (MalformedURLException e) {
            LOG.warn("Invalid gateway url: {}", (Object)gatewayUrl);
            defaultPort = -1;
        }
        if (defaultPort != -1) {
            return this.composeAddressWithPort(host, defaultPort, "Gateway port has default");
        }
        LOG.debug("Gateway cannot be determined, address will be '{}'", (Object)host);
        return host;
    }

    private String composeAddressWithPort(String host, int port, String debugMessage) {
        String gatewayAddress = host + ":" + port;
        LOG.debug(debugMessage + ", address will be '{}'", (Object)gatewayAddress);
        return gatewayAddress;
    }

    private boolean composePlaintext() {
        String protocol;
        return switch (protocol = this.getGrpcAddress().getScheme()) {
            case "http" -> true;
            case "https" -> false;
            default -> throw new IllegalStateException(String.format("Unrecognized zeebe protocol '%s'", protocol));
        };
    }

    public String toString() {
        return "CamundaClientConfigurationImpl{camundaClientProperties=" + String.valueOf(this.camundaClientProperties) + ", jsonMapper=" + String.valueOf(this.jsonMapper) + ", interceptors=" + String.valueOf(this.interceptors) + ", chainHandlers=" + String.valueOf(this.chainHandlers) + ", zeebeClientExecutorService=" + String.valueOf(this.zeebeClientExecutorService) + "}";
    }
}

