/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.spring.client.configuration;

import io.camunda.client.CamundaClient;
import io.camunda.spring.client.actuator.CamundaClientHealthIndicator;
import io.camunda.spring.client.actuator.MicrometerMetricsRecorder;
import io.camunda.spring.client.configuration.MetricsDefaultConfiguration;
import io.camunda.spring.client.metrics.MetricsRecorder;
import io.micrometer.core.instrument.MeterRegistry;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.actuate.autoconfigure.endpoint.EndpointAutoConfiguration;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Lazy;

@AutoConfigureBefore(value={MetricsDefaultConfiguration.class})
@ConditionalOnClass(value={EndpointAutoConfiguration.class, MeterRegistry.class})
public class CamundaActuatorConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public MetricsRecorder micrometerMetricsRecorder(@Autowired @Lazy MeterRegistry meterRegistry) {
        return new MicrometerMetricsRecorder(meterRegistry);
    }

    @Bean
    InitializingBean forceMeterRegistryPostProcessor(@Autowired(required=false) @Qualifier(value="meterRegistryPostProcessor") BeanPostProcessor meterRegistryPostProcessor, @Autowired(required=false) MeterRegistry registry) {
        if (registry == null || meterRegistryPostProcessor == null) {
            return () -> {};
        }
        return () -> meterRegistryPostProcessor.postProcessAfterInitialization((Object)registry, "");
    }

    @Bean
    @ConditionalOnProperty(prefix="management.health.camunda", name={"enabled"}, matchIfMissing=true)
    @ConditionalOnClass(value={HealthIndicator.class})
    @ConditionalOnMissingBean(name={"camundaClientHealthIndicator"})
    public CamundaClientHealthIndicator camundaClientHealthIndicator(CamundaClient client) {
        return new CamundaClientHealthIndicator(client);
    }
}

