/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.spring.client.annotation.processor;

import io.camunda.client.CamundaClient;
import io.camunda.spring.client.annotation.AnnotationUtil;
import io.camunda.spring.client.annotation.customizer.JobWorkerValueCustomizer;
import io.camunda.spring.client.annotation.processor.AbstractCamundaAnnotationProcessor;
import io.camunda.spring.client.annotation.value.JobWorkerValue;
import io.camunda.spring.client.bean.ClassInfo;
import io.camunda.spring.client.jobhandling.JobWorkerManager;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class JobWorkerAnnotationProcessor
extends AbstractCamundaAnnotationProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobWorkerAnnotationProcessor.class);
    private final JobWorkerManager jobWorkerManager;
    private final List<JobWorkerValue> jobWorkerValues = new ArrayList<JobWorkerValue>();
    private final List<JobWorkerValueCustomizer> jobWorkerValueCustomizers;

    public JobWorkerAnnotationProcessor(JobWorkerManager jobWorkerFactory, List<JobWorkerValueCustomizer> jobWorkerValueCustomizers) {
        this.jobWorkerManager = jobWorkerFactory;
        this.jobWorkerValueCustomizers = jobWorkerValueCustomizers;
    }

    @Override
    public boolean isApplicableFor(ClassInfo beanInfo) {
        return AnnotationUtil.isJobWorker(beanInfo);
    }

    @Override
    public void configureFor(ClassInfo beanInfo) {
        ArrayList newJobWorkerValues = new ArrayList();
        ReflectionUtils.doWithMethods(beanInfo.getTargetClass(), method -> AnnotationUtil.getJobWorkerValue(beanInfo.toMethodInfo(method)).ifPresent(newJobWorkerValues::add), (ReflectionUtils.MethodFilter)ReflectionUtils.USER_DECLARED_METHODS);
        LOGGER.info("Configuring {} Zeebe worker(s) of bean '{}': {}", new Object[]{newJobWorkerValues.size(), beanInfo.getBeanName(), newJobWorkerValues});
        this.jobWorkerValues.addAll(newJobWorkerValues);
    }

    @Override
    public void start(CamundaClient client) {
        this.jobWorkerValues.stream().peek(zeebeWorkerValue -> this.jobWorkerValueCustomizers.forEach(customizer -> customizer.customize((JobWorkerValue)zeebeWorkerValue))).filter(JobWorkerValue::getEnabled).forEach(zeebeWorkerValue -> this.jobWorkerManager.openWorker(client, (JobWorkerValue)zeebeWorkerValue));
    }

    @Override
    public void stop(CamundaClient camundaClient) {
        this.jobWorkerManager.closeAllOpenWorkers();
    }
}

