/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.spring.client.annotation.processor;

import io.camunda.client.CamundaClient;
import io.camunda.spring.client.annotation.processor.AbstractCamundaAnnotationProcessor;
import io.camunda.spring.client.bean.ClassInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.Ordered;

public class CamundaAnnotationProcessorRegistry
implements BeanPostProcessor,
Ordered {
    private static final Logger LOG = LoggerFactory.getLogger(CamundaAnnotationProcessorRegistry.class);
    private final Set<AbstractCamundaAnnotationProcessor> processors = new HashSet<AbstractCamundaAnnotationProcessor>();
    private final Map<String, Object> beans = new HashMap<String, Object>();

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof AbstractCamundaAnnotationProcessor) {
            AbstractCamundaAnnotationProcessor processor = (AbstractCamundaAnnotationProcessor)bean;
            this.processors.add(processor);
        }
        return super.postProcessBeforeInitialization(bean, beanName);
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof AbstractCamundaAnnotationProcessor) {
            AbstractCamundaAnnotationProcessor processor = (AbstractCamundaAnnotationProcessor)bean;
            LOG.debug("Found processor: {}", (Object)beanName);
            this.processors.add(processor);
        } else {
            this.beans.put(beanName, bean);
        }
        return bean;
    }

    public List<AbstractCamundaAnnotationProcessor> getProcessors() {
        return new ArrayList<AbstractCamundaAnnotationProcessor>(this.processors);
    }

    public void startAll(CamundaClient client) {
        this.processBeans();
        this.processors.forEach(camundaPostProcessor -> camundaPostProcessor.start(client));
    }

    public void stopAll(CamundaClient client) {
        this.processors.forEach(camundaPostProcessor -> camundaPostProcessor.stop(client));
    }

    private void processBeans() {
        this.beans.forEach((beanName, bean) -> {
            ClassInfo classInfo = ClassInfo.builder().bean(bean).beanName((String)beanName).build();
            for (AbstractCamundaAnnotationProcessor camundaProcessor : this.processors) {
                if (!camundaProcessor.isApplicableFor(classInfo)) continue;
                LOG.debug("Configuring bean {} with post processor {}", beanName, (Object)camundaProcessor.getBeanName());
                camundaProcessor.configureFor(classInfo);
            }
        });
        this.beans.clear();
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

